/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.jwtauth.impl.JwtToken;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
public class GlobalConjurConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConjurConfiguration conjurConfiguration;
    private String authWebServiceId = "";
    private String jwtAudience = "cyberark-conjur";
    private long keyLifetimeInMinutes = 60L;
    private long tokenDurationInSeconds = 120L;
    private String selectAuthenticator = "APIKey";
    private Boolean enableIdentityFormatFieldsFromToken = false;
    private String identityFormatFieldsFromToken = "jenkins_full_name";
    private String selectIdentityFormatToken = "jenkins_full_name";
    private String selectIdentityFieldsSeparator = "-";
    private String identityFieldName = "sub";
    private static final Logger LOGGER = Logger.getLogger(GlobalConjurConfiguration.class.getName());

    public FormValidation doCheckAuthWebServiceId(@AncestorInPath AbstractItem anc, @QueryParameter(value="authWebServiceId") String authWebServiceId) {
        if (StringUtils.isEmpty((String)authWebServiceId) || StringUtils.isBlank((String)authWebServiceId)) {
            LOGGER.log(Level.FINEST, "Auth WebService Id should not be empty");
            return FormValidation.error((String)"Auth WebService Id should not be empty");
        }
        return FormValidation.ok();
    }

    public static GlobalConjurConfiguration get() {
        GlobalConjurConfiguration result = null;
        try {
            result = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
            if (result == null) {
                throw new IllegalStateException();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to retrieve GlobalConjurConfiguration", ex);
        }
        return result;
    }

    public GlobalConjurConfiguration() {
        LOGGER.log(Level.FINEST, "GlobalConjurConfiguration load()");
        this.load();
    }

    public ConjurConfiguration getConjurConfiguration() {
        return this.conjurConfiguration;
    }

    public String getAuthWebServiceId() {
        return this.authWebServiceId;
    }

    @DataBoundSetter
    public void setAuthWebServiceId(String authWebServiceId) {
        this.authWebServiceId = authWebServiceId;
        this.save();
    }

    public String getJwtAudience() {
        return this.jwtAudience;
    }

    public long getKeyLifetimeInMinutes() {
        return this.keyLifetimeInMinutes;
    }

    @DataBoundSetter
    public void setKeyLifetimeInMinutes(long keyLifetimeInMinutes) {
        this.keyLifetimeInMinutes = keyLifetimeInMinutes;
        this.save();
    }

    public long getTokenDurationInSeconds() {
        return this.tokenDurationInSeconds;
    }

    @DataBoundSetter
    public void setTokenDurationInSeconds(long tokenDurationInSeconds) {
        this.tokenDurationInSeconds = tokenDurationInSeconds;
        this.save();
    }

    @DataBoundSetter
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        this.conjurConfiguration = conjurConfiguration;
        this.save();
    }

    public String getSelectAuthenticator() {
        return this.selectAuthenticator;
    }

    @DataBoundSetter
    public void setSelectAuthenticator(String authenticator) {
        LOGGER.log(Level.FINEST, String.format("GlobalConjurConfiguration authenticator set to: %s", authenticator));
        this.selectAuthenticator = authenticator;
        this.save();
    }

    @POST
    public FormValidation doObtainJwtToken(@AncestorInPath ModelObject item) {
        JwtToken token;
        GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        if (item == null) {
            item = Jenkins.get();
        }
        if ((token = JwtToken.getUnsignedToken("pluginAction", item, globalConfig)) != null) {
            return FormValidation.ok((String)("JWT Token: \n" + token.claim.toString(4)));
        }
        return FormValidation.ok((String)"JWT Token: \nCannot obtain token");
    }

    public Boolean getEnableIdentityFormatFieldsFromToken() {
        return this.enableIdentityFormatFieldsFromToken;
    }

    @DataBoundSetter
    public void setEnableIdentityFormatFieldsFromToken(Boolean enableIdentityFormatFieldsFromToken) {
        LOGGER.log(Level.WARNING, "DEPRECATED: GlobalConjurConfiguration get() #enableIdentityFormatFieldsFromToken " + enableIdentityFormatFieldsFromToken);
        this.enableIdentityFormatFieldsFromToken = enableIdentityFormatFieldsFromToken;
        this.save();
    }

    public String getSelectIdentityFormatToken() {
        return this.selectIdentityFormatToken;
    }

    @DataBoundSetter
    public void setSelectIdentityFormatToken(String selectIdentityFormatToken) {
        LOGGER.log(Level.FINEST, "GlobalConjurConfiguration get() #selectIdentityFormatToken " + selectIdentityFormatToken);
        this.selectIdentityFormatToken = selectIdentityFormatToken;
        this.save();
    }

    public String getSelectIdentityFieldsSeparator() {
        return this.selectIdentityFieldsSeparator;
    }

    @DataBoundSetter
    public void setSelectIdentityFieldsSeparator(String selectIdentityFieldsSeparator) {
        this.selectIdentityFieldsSeparator = selectIdentityFieldsSeparator;
        this.save();
    }

    public String getidentityFieldName() {
        return this.identityFieldName;
    }

    @DataBoundSetter
    public void setIdentityFieldName(String identityFieldName) {
        this.identityFieldName = !identityFieldName.isEmpty() ? identityFieldName : "sub";
        this.save();
    }

    public String getIdentityFormatFieldsFromToken() {
        return this.identityFormatFieldsFromToken;
    }

    @DataBoundSetter
    public void setIdentityFormatFieldsFromToken(String identityFormatFieldsFromToken) {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration get() #identityFormatFieldsFromToken " + identityFormatFieldsFromToken);
        this.identityFormatFieldsFromToken = identityFormatFieldsFromToken;
        this.save();
    }
}

