/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.authenticator;

import hudson.model.ModelObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.api.ConjurAuthnInfo;
import org.conjur.jenkins.authenticator.AbstractAuthenticator;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.exceptions.AuthenticationConjurException;
import org.conjur.jenkins.jwtauth.impl.JwtToken;

public class ConjurJWTAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ConjurJWTAuthenticator.class.getName());

    @Override
    public String getName() {
        return "JWT";
    }

    @Override
    public byte[] getAuthorizationToken(ConjurAuthnInfo conjurAuthn, ModelObject context) throws IOException {
        byte[] resultingToken = null;
        LOGGER.log(Level.FINEST, String.format("Authenticating with Conjur (JWT) conjurAuthn.authnPath %s conjurAuthn.account %s conjurAuthn.applianceUrl %s", conjurAuthn.getAuthnPath(), conjurAuthn.getAccount(), conjurAuthn.getApplianceUrl()));
        Request request = null;
        if (conjurAuthn.getApiKey() != null && conjurAuthn.getAuthnPath() != null) {
            Object authnPath = !conjurAuthn.getAuthnPath().contains("/") ? "authn-jwt/" + conjurAuthn.getAuthnPath() : conjurAuthn.getAuthnPath();
            request = new Request.Builder().url(String.format("%s/%s/%s/authenticate", conjurAuthn.getApplianceUrl(), authnPath, conjurAuthn.getAccount())).post(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (byte[])conjurAuthn.getApiKey())).build();
        }
        if (request != null) {
            OkHttpClient client = ConjurAPIUtils.getHttpClient(conjurAuthn.getConjurConfiguration());
            Response response = client.newCall(request).execute();
            ResponseBody body = response.body();
            if (body != null) {
                byte[] respMessage = body.string().getBytes(StandardCharsets.UTF_8);
                resultingToken = Base64.getEncoder().withoutPadding().encodeToString(respMessage).getBytes(StandardCharsets.US_ASCII);
                LOGGER.log(Level.FINEST, () -> "Conjur Authenticate response " + response.code() + " - " + response.message());
            }
            if (response.code() != 200) {
                if (response.code() == 401) {
                    throw new AuthenticationConjurException(response.code());
                }
                throw new IOException("[" + response.code() + "] - " + response.message());
            }
        } else {
            LOGGER.log(Level.SEVERE, "Cannot create http call. JWTAuthentication failed.");
        }
        return resultingToken;
    }

    @Override
    public void fillAuthnInfo(ConjurAuthnInfo conjurAuthn, ModelObject context) {
        GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        String jwtToken = JwtToken.getToken(context, globalConfig);
        conjurAuthn.setLogin(null);
        if (globalConfig != null) {
            conjurAuthn.setAuthnPath(globalConfig.getAuthWebServiceId());
        }
        byte[] jwtNameBytes = "jwt=".getBytes(StandardCharsets.US_ASCII);
        byte[] jwtTokenBytes = jwtToken.getBytes(StandardCharsets.US_ASCII);
        byte[] jwt = new byte[jwtNameBytes.length + jwtTokenBytes.length];
        System.arraycopy(jwtNameBytes, 0, jwt, 0, jwtNameBytes.length);
        System.arraycopy(jwtTokenBytes, 0, jwt, jwtNameBytes.length, jwtTokenBytes.length);
        conjurAuthn.setApiKey(jwt);
    }
}

