/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice;

import hudson.model.AbstractItem;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractUnoChoiceParameter;
import org.biouno.unochoice.ScriptableParameter;
import org.biouno.unochoice.model.Script;
import org.biouno.unochoice.util.ScriptCallback;
import org.biouno.unochoice.util.Utils;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AbstractScriptableParameter
extends AbstractUnoChoiceParameter
implements ScriptableParameter<Map<Object, Object>> {
    private static final long serialVersionUID = 1322134413144485771L;
    protected static final String SEPARATOR = "__LESEP__";
    protected static final String EQUALS = "=";
    protected static final String JENKINS_PROJECT_VARIABLE_NAME = "jenkinsProject";
    protected static final String JENKINS_BUILD_VARIABLE_NAME = "jenkinsBuild";
    protected static final String JENKINS_PARAMETER_VARIABLE_NAME = "jenkinsParameter";
    private volatile int visibleItemCount = 1;
    protected final Script script;
    private final String projectName;
    private final String projectFullName;
    private String cachedDefaultValue;

    @Deprecated
    protected AbstractScriptableParameter(String name, String description, Script script) {
        super(name, description);
        this.script = script;
        this.projectName = null;
        this.projectFullName = null;
    }

    protected AbstractScriptableParameter(String name, String description, String randomName, Script script) {
        super(name, description, randomName);
        this.script = script;
        String projectName = null;
        String projectFullName = null;
        AbstractItem parentItem = this.detectProject();
        if (parentItem != null) {
            projectName = parentItem.getName();
            projectFullName = parentItem.getFullName();
        }
        this.projectName = projectName;
        this.projectFullName = projectFullName;
    }

    protected AbstractItem detectProject() {
        Object o;
        Ancestor ancestor;
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        if (currentRequest != null && (ancestor = currentRequest.findAncestor(AbstractItem.class)) != null && (o = ancestor.getObject()) instanceof AbstractItem) {
            return (AbstractItem)o;
        }
        return null;
    }

    public Script getScript() {
        return this.script;
    }

    public Map<Object, Object> getParameters() {
        return Collections.emptyMap();
    }

    private Map<Object, Object> getHelperParameters() {
        LinkedHashMap<Object, Object> helperParameters = new LinkedHashMap<Object, Object>();
        Project project = null;
        if (StringUtils.isNotBlank((String)this.projectFullName)) {
            project = (Project)Jenkins.get().getItemByFullName(this.projectFullName, Project.class);
        } else if (StringUtils.isNotBlank((String)this.projectName)) {
            project = Utils.getProjectByName(this.projectName);
        } else {
            AbstractItem parentItem = this.detectProject();
            if (parentItem != null) {
                project = (Job)Jenkins.get().getItemByFullName(parentItem.getFullName(), Job.class);
            }
        }
        if (project == null) {
            project = Utils.findProjectByParameterUUID(this.getRandomName());
        }
        if (project != null) {
            helperParameters.put(JENKINS_PROJECT_VARIABLE_NAME, project);
            Run build = project.getLastBuild();
            if (build != null && build.getHasArtifacts()) {
                helperParameters.put(JENKINS_BUILD_VARIABLE_NAME, build);
            }
        }
        helperParameters.put(JENKINS_PARAMETER_VARIABLE_NAME, this);
        Map<String, Object> globalNodeProperties = Utils.getGlobalNodeProperties();
        helperParameters.putAll(globalNodeProperties);
        return helperParameters;
    }

    public Map<Object, Object> getChoices() {
        Object choices = this.getChoices((Map)this.getParameters());
        this.visibleItemCount = choices.size();
        return choices;
    }

    @Override
    public Map<Object, Object> getChoices(Map<Object, Object> parameters) {
        Object value = this.eval(parameters);
        if (value instanceof Map) {
            Map map = (Map)value;
            this.visibleItemCount = map.size();
            return map;
        }
        if (value instanceof List) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (Object o : (List)value) {
                map.put(o, o);
            }
            this.visibleItemCount = map.size();
            return map;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Script parameter with name '%s' is not an instance of java.util.Map. The parameter value is %s", this.getName(), value));
        }
        return Collections.emptyMap();
    }

    public String getChoicesAsString() {
        return this.getChoicesAsString(this.getParameters());
    }

    public String getChoicesAsString(Map<Object, Object> parameters) {
        Object value = this.eval(parameters);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private Object eval(Map<Object, Object> parameters) {
        try {
            Map<Object, Object> scriptParameters = this.getHelperParameters();
            scriptParameters.putAll(parameters);
            ScriptCallback callback = new ScriptCallback(this.getName(), this.script, scriptParameters);
            return callback.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error executing script for dynamic parameter", e);
            return Collections.emptyMap();
        }
    }

    public ParameterValue getDefaultParameterValue() {
        String value;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "getDefaultParameterValue");
        }
        String name = this.getName();
        if (this.cachedDefaultValue != null) {
            return new StringParameterValue(name, this.cachedDefaultValue);
        }
        String defaultValue = AbstractScriptableParameter.findDefaultValue((Map<Object, Object>)this.getChoices(Collections.emptyMap()));
        this.cachedDefaultValue = value = ObjectUtils.toString((Object)defaultValue, (String)"");
        return new StringParameterValue(name, value);
    }

    private static String findDefaultValue(Map<Object, Object> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        ArrayList<String> defaultValues = new ArrayList<String>();
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(choices.entrySet());
        for (Map.Entry entry : entries) {
            String valueText = ObjectUtils.toString(entry.getValue(), (String)"");
            if (!Utils.isSelected(valueText)) continue;
            String keyText = ObjectUtils.toString(entry.getKey(), (String)"");
            defaultValues.add(Utils.escapeSelectedAndDisabled(keyText));
        }
        if (defaultValues.isEmpty()) {
            String keyText = ObjectUtils.toString(((Map.Entry)entries.get(0)).getKey(), (String)"");
            return ObjectUtils.toString((Object)keyText, (String)"");
        }
        StringBuilder defaultValuesText = new StringBuilder();
        for (String value : defaultValues) {
            defaultValuesText.append(',');
            defaultValuesText.append(value);
        }
        return defaultValuesText.substring(1);
    }

    public int getVisibleItemCount() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "getVisibleItemCount");
        }
        if (this.visibleItemCount <= 0) {
            this.visibleItemCount = 1;
        }
        return Math.min(this.visibleItemCount, 10);
    }

    public int getItemCount() {
        if (this.visibleItemCount <= 0) {
            this.visibleItemCount = 1;
        }
        return this.visibleItemCount;
    }
}

