/*
 * Decompiled with CFR 0.152.
 */
package nl.arnom.jenkins.fasttrack.rules;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import javax.annotation.Nonnull;
import nl.arnom.jenkins.fasttrack.rules.AbstractLastCompletedBuildSortRule;
import nl.arnom.jenkins.fasttrack.rules.SortRule;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class WorsePreviousResultSortRule
extends AbstractLastCompletedBuildSortRule {
    @DataBoundConstructor
    public WorsePreviousResultSortRule() {
    }

    @Override
    protected SortRule.SortResult sortUsingLastCompletedBuild(Run<?, ?> first, Run<?, ?> second) {
        Result secondResult;
        Result firstResult = first.getResult();
        SortRule.SortResult result = this.preferNotNull(firstResult, secondResult = second.getResult());
        if (result != null) {
            return result;
        }
        if (firstResult.equals(secondResult)) {
            return SortRule.SortResult.NO_PREFERENCE;
        }
        if (firstResult.isWorseThan(secondResult)) {
            return SortRule.SortResult.FIRST;
        }
        return SortRule.SortResult.SECOND;
    }

    @Extension
    @Symbol(value={"worsePreviousResultSortRule"})
    public static class DescriptorImpl
    extends Descriptor<SortRule> {
        @Nonnull
        public String getDisplayName() {
            return "Prefer builds of which the last build has the worst result";
        }
    }
}

