/*
 * Decompiled with CFR 0.152.
 */
package nl.arnom.jenkins.fasttrack.rules;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.util.Objects;
import javax.annotation.Nonnull;
import nl.arnom.jenkins.fasttrack.rules.AbstractJobSortRule;
import nl.arnom.jenkins.fasttrack.rules.SortRule;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ShorterEstimatedDurationSortRule
extends AbstractJobSortRule {
    private final int minimumDeltaSeconds;

    public ShorterEstimatedDurationSortRule() {
        this(30);
    }

    @DataBoundConstructor
    public ShorterEstimatedDurationSortRule(int minimumDeltaSeconds) {
        this.minimumDeltaSeconds = minimumDeltaSeconds;
    }

    public int getMinimumDeltaSeconds() {
        return this.minimumDeltaSeconds;
    }

    @Override
    protected SortRule.SortResult sortUsingJobs(Job<?, ?> first, Job<?, ?> second) {
        Long firstDuration = this.getEstimatedDuration(first);
        Long secondDuration = this.getEstimatedDuration(second);
        if (firstDuration == null || secondDuration == null) {
            return SortRule.SortResult.NO_PREFERENCE;
        }
        long delta = firstDuration - secondDuration;
        if (delta == 0L || Math.abs(delta) < (long)this.minimumDeltaSeconds) {
            return SortRule.SortResult.NO_PREFERENCE;
        }
        if (delta < 0L) {
            return SortRule.SortResult.FIRST;
        }
        return SortRule.SortResult.SECOND;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShorterEstimatedDurationSortRule that = (ShorterEstimatedDurationSortRule)((Object)o);
        return this.minimumDeltaSeconds == that.minimumDeltaSeconds;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minimumDeltaSeconds);
    }

    private Long getEstimatedDuration(Job<?, ?> job) {
        if (job.getLastCompletedBuild() != null) {
            return job.getEstimatedDuration();
        }
        return null;
    }

    @Extension
    @Symbol(value={"shorterEstimatedDurationSortRule"})
    public static class DescriptorImpl
    extends Descriptor<SortRule> {
        public FormValidation doCheckMinimumDeltaSeconds(@QueryParameter String value) {
            try {
                int input = Integer.parseUnsignedInt(value);
                if (input >= 0) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Valid positive number or zero required.");
            }
            catch (Throwable e) {
                return FormValidation.error((Throwable)e, (String)"Valid positive number or zero required.");
            }
        }

        @Nonnull
        public String getDisplayName() {
            return "Prefer builds of which the estimated duration is less";
        }
    }
}

