/*
 * Decompiled with CFR 0.152.
 */
package nl.arnom.jenkins.fasttrack;

import com.google.common.collect.Lists;
import hudson.Extension;
import java.util.Collections;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import nl.arnom.jenkins.fasttrack.rules.BuildStartedByUserSortRule;
import nl.arnom.jenkins.fasttrack.rules.LongerWaitTimeSortRule;
import nl.arnom.jenkins.fasttrack.rules.ShorterEstimatedDurationSortRule;
import nl.arnom.jenkins.fasttrack.rules.SortRule;
import nl.arnom.jenkins.fasttrack.rules.UpstreamCauseSortRule;
import nl.arnom.jenkins.fasttrack.rules.WorsePreviousResultSortRule;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"fastTrack"})
public class FastTrackConfiguration
extends GlobalConfiguration {
    private List<SortRule> sortRules = Lists.newArrayList();

    public FastTrackConfiguration() {
        this.load();
        if (this.sortRules.isEmpty()) {
            this.sortRules.add(new UpstreamCauseSortRule());
            this.sortRules.add(new BuildStartedByUserSortRule());
            this.sortRules.add(new LongerWaitTimeSortRule(90, 15));
            this.sortRules.add(new WorsePreviousResultSortRule());
            this.sortRules.add(new ShorterEstimatedDurationSortRule());
        }
    }

    public static FastTrackConfiguration get() {
        return (FastTrackConfiguration)((Object)GlobalConfiguration.all().get(FastTrackConfiguration.class));
    }

    public SortRule[] getSortRules() {
        return this.sortRules.toArray(new SortRule[0]);
    }

    public void setSortRules(SortRule[] sortRules) {
        if (sortRules != null) {
            this.sortRules.clear();
            for (SortRule rule : sortRules) {
                if (this.sortRules.contains((Object)rule)) continue;
                this.sortRules.add(rule);
            }
        }
        this.save();
    }

    public List<SortRule> getSortRuleCollection() {
        return Collections.unmodifiableList(this.sortRules);
    }

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Unclassified.class);
    }
}

