/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class ResolveNextCommit
implements FilePath.FileCallable<RevCommit> {
    private String commitId;
    private String name;
    private String branch = "git";

    public ResolveNextCommit(String name, String commitId) {
        this.commitId = commitId;
        this.name = name;
    }

    public RevCommit invoke(File workspace, VirtualChannel virtualChannel) throws IOException, InterruptedException {
        RevCommit c;
        Logger logger = Logger.getLogger(ResolveNextCommit.class.getName());
        File local = new File(workspace, this.name);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        logger.fine("Initializing repo");
        FileRepository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(local, ".git"))).readEnvironment()).findGitDir()).build();
        Git git = new Git((Repository)repo);
        logger.fine("Updating to " + this.branch);
        try {
            logger.fine("Pulling");
            git.pull().call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        RevWalk w = new RevWalk((Repository)repo);
        ObjectId ohead = repo.resolve("HEAD");
        ObjectId ostart = repo.resolve(this.commitId);
        RevCommit commithead = w.parseCommit((AnyObjectId)ohead);
        RevCommit commit = w.parseCommit((AnyObjectId)ostart);
        logger.fine("Commit start: " + this.commitId);
        w.markStart(commithead);
        RevCommit next = null;
        Iterator i$ = w.iterator();
        while (i$.hasNext() && ((c = (RevCommit)i$.next()) == null || !c.equals((AnyObjectId)commit)) && c != null) {
            if (c.getParentCount() > 1) continue;
            next = c;
        }
        w.dispose();
        logger.fine("Next is " + (next == null ? "N/A" : next.getName()));
        return next;
    }
}

