/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import net.praqma.jenkins.configrotator.scm.git.GitConfigurationComponent;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class ResolveConfigurationComponent
implements FilePath.FileCallable<GitConfigurationComponent> {
    private String name;
    private String repository;
    private String branch;
    private String commitId;
    private boolean fixed;
    private TaskListener listener;

    public ResolveConfigurationComponent(TaskListener listener, String name, String repository, String branch, String commitId, boolean fixed) {
        this.name = name;
        this.repository = repository;
        this.branch = branch;
        this.commitId = commitId;
        this.fixed = fixed;
        this.listener = listener;
    }

    public GitConfigurationComponent invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        Logger logger = Logger.getLogger(ResolveConfigurationComponent.class.getName());
        if (this.name == null || this.name.equals("")) {
            this.name = this.repository.substring(this.repository.lastIndexOf("/"));
            if (this.name.matches(".*?\\.git$")) {
                this.name = this.name.substring(0, this.name.length() - 4);
            }
            if (this.name.startsWith("/")) {
                this.name = this.name.substring(1);
            }
        }
        logger.fine("Name: " + this.name);
        if (this.branch == null || this.branch.equals("")) {
            this.branch = "master";
        }
        File local = new File(workspace, this.name);
        try {
            logger.fine("Cloning repo from " + this.repository);
            try {
                Git.cloneRepository().setURI(this.repository).setDirectory(local).setCloneAllBranches(true).call();
            }
            catch (JGitInternalException e) {
                logger.warning(e.getMessage());
            }
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            FileRepository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(local, ".git"))).readEnvironment()).findGitDir()).build();
            Git git = new Git((Repository)repo);
            try {
                logger.fine("Creating branch " + this.branch);
                git.branchCreate().setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setName(this.branch).setStartPoint("origin/" + this.branch).call();
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
            }
            try {
                logger.fine("Pulling");
                git.pull().call();
            }
            catch (GitAPIException e) {
                throw new IOException(e);
            }
            RevWalk w = new RevWalk((Repository)repo);
            logger.fine("The commit id: " + this.commitId);
            if (this.commitId == null || this.commitId.matches("^\\s*$")) {
                logger.fine("Initial commit not defined, using HEAD");
                this.listener.getLogger().println("[ConfigRotator] Initial commit not defined, using HEAD");
                this.commitId = "HEAD";
            }
            logger.fine("Getting commit \"" + this.commitId + "\"");
            ObjectId o = repo.resolve(this.commitId);
            RevCommit commit = w.parseCommit((AnyObjectId)o);
            logger.fine("RevCommit: " + commit);
            return new GitConfigurationComponent(this.name, this.repository, this.branch, commit, this.fixed);
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    private void listPath(PrintStream logger, File path) {
        logger.println("PATH: " + path);
        for (String f : path.list()) {
            logger.println(" * " + f);
        }
    }
}

