/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Logger;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;
import net.praqma.jenkins.configrotator.scm.git.Checkout;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitConfigurationComponent
extends AbstractConfigurationComponent {
    private static Logger logger = Logger.getLogger(GitConfigurationComponent.class.getName());
    private transient RevCommit commit;
    private String commitId;
    private String name;
    private String branch;
    private String repository;

    private GitConfigurationComponent(String name, String repository, String branch, String commitId, boolean fixed) {
        super(fixed);
        this.name = name;
        this.repository = repository;
        this.branch = branch;
        this.commitId = commitId;
    }

    public GitConfigurationComponent(String name, String repository, String branch, RevCommit commit, boolean fixed) {
        super(fixed);
        this.commit = commit;
        if (commit != null) {
            this.commitId = commit.getName();
        }
        this.name = name;
        this.branch = branch;
        this.repository = repository;
    }

    public void checkout(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        workspace.act((FilePath.FileCallable)new Checkout(this.name, this.branch, this.commitId));
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.name;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public String getCommitId() {
        return this.commitId;
    }

    @Override
    public String getComponentName() {
        return this.repository;
    }

    protected Object clone() {
        GitConfigurationComponent gcc = new GitConfigurationComponent(this.name, this.repository, this.branch, this.commitId, this.fixed);
        return gcc;
    }

    @Override
    public String getFeedId() {
        return this.repository;
    }

    @Override
    public String getFeedName() {
        return this.repository;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GitConfigurationComponent) {
            GitConfigurationComponent o = (GitConfigurationComponent)other;
            logger.finest("Other: " + o.commitId + " == " + this.commitId);
            return o.commitId.equals(this.commitId) && o.isFixed() == this.fixed;
        }
        return false;
    }

    public String toString() {
        return "GC[" + this.commitId + "]";
    }

    @Override
    public String prettyPrint() {
        return this.name + ": " + this.repository + ", " + this.branch + ", " + this.commitId;
    }

    @Override
    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        return this.getBasicHtml(builder, new AbstractConfigurationComponent.Element(this.repository, this.isChangedLast()), new AbstractConfigurationComponent.Element(this.branch, this.isChangedLast()), new AbstractConfigurationComponent.Element(this.commitId, this.isChangedLast()), new AbstractConfigurationComponent.Element(this.fixed + "", this.isChangedLast()));
    }
}

