/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.praqma.jenkins.configrotator.scm.git.GitConfigurationComponent;
import net.praqma.jenkins.configrotator.scm.git.GitTarget;
import net.praqma.jenkins.configrotator.scm.git.ResolveConfigurationComponent;

public class GitConfiguration
extends AbstractConfiguration<GitConfigurationComponent> {
    private static Logger logger = Logger.getLogger(GitConfiguration.class.getName());

    private GitConfiguration() {
    }

    public GitConfiguration(List<GitTarget> targets, FilePath workspace, TaskListener listener) throws ConfigurationRotatorException {
        Iterator<GitTarget> i$ = targets.iterator();
        while (i$.hasNext()) {
            GitTarget t;
            GitTarget target = t = i$.next();
            logger.fine("Getting component for " + target);
            GitConfigurationComponent c = null;
            try {
                c = (GitConfigurationComponent)workspace.act((FilePath.FileCallable)new ResolveConfigurationComponent(listener, target.getName(), target.getRepository(), target.getBranch(), target.getCommitId(), target.getFixed()));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Whoops", e);
                throw new ConfigurationRotatorException("Unable to get component for " + target, e);
            }
            logger.fine("Adding " + c);
            this.list.add(c);
        }
    }

    public void checkout(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        for (GitConfigurationComponent c : this.getList()) {
            c.checkout(workspace, listener);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GitConfiguration) {
            GitConfiguration o = (GitConfiguration)other;
            if (o.getList().size() != this.list.size()) {
                return false;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (((GitConfigurationComponent)o.list.get(i)).equals(this.list.get(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public List<ConfigRotatorChangeLogEntry> difference(GitConfigurationComponent component, GitConfigurationComponent other) throws ConfigurationRotatorException {
        return null;
    }

    @Override
    public GitConfiguration clone() {
        GitConfiguration n = new GitConfiguration();
        for (GitConfigurationComponent gc : this.list) {
            n.list.add((GitConfigurationComponent)gc.clone());
        }
        return n;
    }

    @Override
    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        return this.basicHtml(builder, "Repository", "Branch", "Commit", "Fixed");
    }
}

