/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class Checkout
implements FilePath.FileCallable<Boolean> {
    private String commitId;
    private String name;
    private String branch;

    public Checkout(String name, String branch, String commitId) {
        this.commitId = commitId;
        this.name = name;
        this.branch = branch;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        File local = new File(workspace, this.name);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        FileRepository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(local, ".git"))).readEnvironment()).findGitDir()).build();
        Git git = new Git((Repository)repo);
        try {
            git.checkout().setName(this.branch).setAllPaths(true).setForce(true).setStartPoint(this.commitId).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        return true;
    }
}

