/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.clearcaseucm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.interfaces.Diffable;
import net.praqma.clearcase.ucm.entities.Activity;
import net.praqma.clearcase.ucm.entities.Version;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorVersion;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMConfigurationComponent;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMTarget;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.GetConfiguration;

public class ClearCaseUCMConfiguration
extends AbstractConfiguration<ClearCaseUCMConfigurationComponent> {
    private static Logger logger = Logger.getLogger(ClearCaseUCMConfiguration.class.getName());
    private SnapshotView view;

    public ClearCaseUCMConfiguration() {
    }

    @Override
    public ClearCaseUCMConfiguration clone() {
        ClearCaseUCMConfiguration n = new ClearCaseUCMConfiguration();
        n.view = this.view;
        for (ClearCaseUCMConfigurationComponent cc : this.list) {
            n.list.add(cc.clone());
        }
        return n;
    }

    public ClearCaseUCMConfiguration(List<ClearCaseUCMConfigurationComponent> list) {
        this.list = list;
    }

    public void setView(SnapshotView view) {
        this.view = view;
    }

    public SnapshotView getView() {
        return this.view;
    }

    public static ClearCaseUCMConfiguration getConfigurationFromTargets(List<ClearCaseUCMTarget> targets, FilePath workspace, TaskListener listener) throws ConfigurationRotatorException {
        PrintStream out = listener.getLogger();
        ClearCaseUCMConfiguration configuration = new ClearCaseUCMConfiguration();
        for (ClearCaseUCMTarget target : targets) {
            String[] units = target.getComponent().split(",");
            if (units.length == 3) {
                try {
                    ClearCaseUCMConfigurationComponent config = (ClearCaseUCMConfigurationComponent)workspace.act((FilePath.FileCallable)new GetConfiguration(units, listener));
                    configuration.list.add(config);
                    out.println("[ConfigRotator] Parsed configuration: " + config);
                    continue;
                }
                catch (InterruptedException e) {
                    out.println("[ConfigRotator] Error parsing configuration - interrupted: " + e.getMessage());
                    throw new ConfigurationRotatorException("Unable parse configuration - interrupted", e);
                }
                catch (IOException ioe) {
                    try {
                        Exception cce = (Exception)ioe.getCause();
                        throw cce;
                    }
                    catch (ClearCaseException cce) {
                        out.println("[ConfigRotator] Unable to load with ClearCase: " + cce.getMessage());
                        throw new ConfigurationRotatorException("Unable to load with ClearCase", (Exception)((Object)cce));
                    }
                    catch (Exception e2) {
                        out.println("[ConfigRotator] Error parsing configuration - io: " + e2.getMessage());
                        throw new ConfigurationRotatorException("Unable parse configuration - io", e2);
                    }
                }
            }
            out.println("[ConfigRotator] \"" + target.getComponent() + "\" was not correct");
            throw new ConfigurationRotatorException("Wrong input, length is " + units.length);
        }
        return configuration;
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ClearCaseUCMConfiguration) {
            ClearCaseUCMConfiguration o = (ClearCaseUCMConfiguration)other;
            if (o.getList().size() != this.list.size()) {
                return false;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (((ClearCaseUCMConfigurationComponent)o.list.get(i)).equals(this.list.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<table border=\"0\" style=\"text-align:left;\">");
        builder.append("<thead>");
        builder.append("<th>").append("Component").append("</th>");
        builder.append("<th>").append("Stream").append("</th>");
        builder.append("<th>").append("Baseline").append("</th>");
        builder.append("<th>").append("Promotion level").append("</th>");
        builder.append("<th>").append("Fixed").append("</th>");
        for (ClearCaseUCMConfigurationComponent comp : this.getList()) {
            builder.append(comp.toHtml());
        }
        builder.append("</thead>");
        builder.append("</table>");
        return builder.toString();
    }

    @Override
    public String getDescription(AbstractBuild<?, ?> build) {
        if (this.description == null) {
            ConfigurationRotator rotator = (ConfigurationRotator)build.getProject().getScm();
            if (this.getChangedComponent() == null) {
                return "New Configuration - no changes yet";
            }
            int currentComponentIndex = this.getChangedComponentIndex();
            String currentBaseline = ((ClearCaseUCMConfigurationComponent)this.getChangedComponent()).getBaseline().getNormalizedName();
            ConfigurationRotatorBuildAction previous = rotator.getAcrs().getPreviousResult(build, null);
            String previousBaseline = ((ClearCaseUCMConfigurationComponent)((ClearCaseUCMConfiguration)previous.getConfiguration()).getList().get(currentComponentIndex)).getBaseline().getNormalizedName();
            return String.format("Baseline changed from %s to %s", previousBaseline, currentBaseline);
        }
        return this.description;
    }

    @Override
    public List<ConfigRotatorChangeLogEntry> difference(ClearCaseUCMConfigurationComponent component, ClearCaseUCMConfigurationComponent other) throws ConfigurationRotatorException {
        LinkedList<ConfigRotatorChangeLogEntry> entries = new LinkedList<ConfigRotatorChangeLogEntry>();
        List components = this.getList();
        try {
            List activities = Version.getBaselineDiff((Diffable)component.getBaseline(), (Diffable)(other != null ? other.getBaseline() : null), (boolean)false, (File)new File(this.getView().getPath()));
            for (Activity a : activities) {
                ConfigRotatorChangeLogEntry entry = new ConfigRotatorChangeLogEntry(a.getHeadline(), a.getUser(), new ArrayList<ConfigRotatorVersion>());
                for (Version v : a.changeset.versions) {
                    entry.addVersion(new ConfigRotatorVersion(v.getSFile(), v.getVersion(), v.blame()));
                }
                entries.add(entry);
            }
        }
        catch (ClearCaseException e) {
            logger.log(Level.WARNING, "Unable to generate change log entries", e);
        }
        return entries;
    }
}

