/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import net.praqma.jenkins.configrotator.AbstractPostConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorProjectAction;
import net.praqma.jenkins.configrotator.DiedBecauseAction;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class ConfigurationRotatorPublisher
extends Notifier {
    private static Logger logger = Logger.getLogger(ConfigurationRotatorPublisher.class.getName());

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream out = listener.getLogger();
        if (build.getProject().getScm() instanceof ConfigurationRotator) {
            logger.fine("SCM is part of ConfigRotator");
            ConfigurationRotatorBuildAction action = (ConfigurationRotatorBuildAction)build.getAction(ConfigurationRotatorBuildAction.class);
            logger.fine("Action object is: " + action);
            if (action != null) {
                if (build.getResult().isBetterOrEqualTo(Result.SUCCESS)) {
                    action.setResult(ConfigurationRotator.ResultType.COMPATIBLE);
                } else {
                    action.setResult(ConfigurationRotator.ResultType.INCOMPATIBLE);
                }
                out.println("[ConfigRotator] Configuration is " + (Object)((Object)action.getResult()));
                return AbstractPostConfigurationRotator.doit(build.getWorkspace(), (TaskListener)listener, action);
            }
            DiedBecauseAction da = (DiedBecauseAction)build.getAction(DiedBecauseAction.class);
            out.println("[ConfigRotator] Action was null, unable to set compatibility of configuration");
            logger.fine("Die action: " + da);
            if (da != null) {
                logger.fine(da.toString());
                if (!da.died()) {
                    this.hadNothingToDo(build);
                }
            }
        } else {
            out.println("[ConfigRotator] SCM not part of ConfigRotator");
        }
        return true;
    }

    public void hadNothingToDo(AbstractBuild build) throws IOException {
        String d = build.getDescription();
        if (d != null) {
            build.setDescription((d.length() > 0 ? d + "<br/>" : "") + "Nothing to do");
        } else {
            build.setDescription("Nothing to do");
        }
        build.setResult(Result.NOT_BUILT);
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new ConfigurationRotatorProjectAction(project));
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new ConfigurationRotatorPublisher();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Configuration Rotator Publisher";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public DescriptorImpl() {
            super(ConfigurationRotatorPublisher.class);
            this.load();
        }
    }
}

