/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.model.Action;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.util.xml.feed.AtomPublisher;
import net.praqma.util.xml.feed.Feed;
import net.praqma.util.xml.feed.FeedPublisher;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ConfigurationRotatorFeedAction
implements Action {
    private static Logger logger = Logger.getLogger(ConfigurationRotatorFeedAction.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public abstract String getComponentName();

    public String getFeedUrl(String component) {
        return Jenkins.getInstance().getRootUrl() + "config-rotator" + "/" + this.getComponentName() + "/feed?component=" + component;
    }

    public String getComponentName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public ArrayList<File> getComponents() {
        FileFilter xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        };
        return this.getComponents(xmlFilter);
    }

    public String getFeedTitle(File feed) {
        String title = "Unknown";
        try {
            title = Feed.getFeed((FeedPublisher)new AtomPublisher(), (File)feed).title;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return title;
    }

    public ArrayList<File> getComponents(FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        File path = new File(ConfigurationRotator.getFeedPath(), this.getComponentName());
        for (File f : path.listFiles(filter)) {
            list.add(f);
        }
        return list;
    }

    public void doFeed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String component = req.getParameter("component");
        File file = new File(new File(ConfigurationRotator.getFeedPath(), this.getComponentName()), component + ".xml");
        if (file != null && file.exists()) {
            rsp.serveFile(req, (InputStream)FileUtils.openInputStream((File)file), file.lastModified(), file.getTotalSpace(), file.getName());
        } else {
            rsp.sendError(404);
        }
    }
}

