/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorPublisher;
import net.praqma.jenkins.configrotator.ConfigurationRotatorSCMDescriptor;
import net.praqma.jenkins.configrotator.DiedBecauseAction;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ConfigurationRotator
extends SCM {
    private AbstractConfigurationRotatorSCM acrs;
    private boolean printDebug = false;
    private static Logger logger = Logger.getLogger(ConfigurationRotator.class.getName());
    public static final String URL_NAME = "config-rotator";
    public static final String NAME = "ConfigRotator";
    public static final String LOGGERNAME = "[ConfigRotator] ";
    public boolean justConfigured = false;
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final String FEED_DIR = "config-rotator-feeds" + SEPARATOR;
    private static File FEED_PATH;
    private static String VERSION;
    public boolean reconfigure;

    public static final File getFeedPath() {
        return FEED_PATH;
    }

    @DataBoundConstructor
    public ConfigurationRotator(AbstractConfigurationRotatorSCM acrs) {
        this.acrs = acrs;
        this.justConfigured = true;
    }

    public AbstractConfigurationRotatorSCM getAcrs() {
        return this.acrs;
    }

    public boolean doReconfigure() {
        return this.reconfigure;
    }

    public void setReconfigure(boolean reconfigure) {
        this.reconfigure = reconfigure;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> arg0, Launcher arg1, TaskListener arg2) throws IOException, InterruptedException {
        if (!this.doReconfigure()) {
            return new SCMRevisionState(){};
        }
        return null;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File file) throws IOException, InterruptedException {
        PrintStream out = listener.getLogger();
        out.println("[ConfigRotator] Version: " + VERSION);
        logger.fine("Version: " + VERSION);
        if (this.justConfigured) {
            this.reconfigure = this.acrs.wasReconfigured(build.getProject());
            logger.fine("Was reconfigured: " + this.reconfigure);
        }
        AbstractConfigurationRotatorSCM.Performer performer = this.acrs.getPerform(build, launcher, workspace, listener);
        ConfigurationRotatorBuildAction lastAction = this.acrs.getLastResult(build.getProject(), performer.getSCMClass());
        AbstractConfiguration configuration = null;
        this.ensurePublisher(build);
        boolean performResult = false;
        try {
            if (this.reconfigure || lastAction == null) {
                out.println("[ConfigRotator] Configuration from scratch");
                configuration = (AbstractConfiguration)performer.getInitialConfiguration();
            } else {
                out.println("[ConfigRotator] Getting next configuration");
                configuration = (AbstractConfiguration)performer.getNextConfiguration(lastAction);
            }
            this.acrs.printConfiguration(out, configuration);
            if (configuration != null) {
                out.println("[ConfigRotator] Checking configuration(" + configuration.getClass() + ") " + configuration);
                performer.checkConfiguration(configuration);
                out.println("[ConfigRotator] Creating workspace");
                performer.createWorkspace(configuration);
                performer.save(configuration);
                performResult = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to create configuration", e);
            e.printStackTrace(out);
            DiedBecauseAction da = new DiedBecauseAction(e.getMessage(), DiedBecauseAction.Die.die);
            build.addAction((Action)da);
            throw new AbortException(e.getMessage());
        }
        if (!performResult) {
            DiedBecauseAction da = new DiedBecauseAction("Nothing to rotate", DiedBecauseAction.Die.survive);
            build.addAction((Action)da);
            throw new AbortException("Nothing new to rotate");
        }
        AbstractConfigurationRotatorSCM.ChangeLogWriter clw = this.acrs.getChangeLogWriter(file, listener, build);
        try {
            List<ConfigRotatorChangeLogEntry> entries = null;
            if (clw != null) {
                entries = lastAction == null || this.reconfigure ? Collections.emptyList() : clw.getChangeLogEntries(configuration);
                clw.write(entries);
            } else {
                logger.info("Change log writer not implemented");
                out.println("[ConfigRotator] Change log writer not implemented");
                entries = Collections.emptyList();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Change log not generated", e);
            out.println("[ConfigRotator] Change log not generated");
        }
        this.reconfigure = false;
        this.justConfigured = false;
        build.getProject().save();
        return true;
    }

    public void ensurePublisher(AbstractBuild build) throws IOException {
        Describable describable = build.getProject().getPublishersList().get(ConfigurationRotatorPublisher.class);
        if (describable == null) {
            logger.info("Adding publisher to project");
            build.getProject().getPublishersList().add((Object)new ConfigurationRotatorPublisher());
        }
    }

    public void setConfigurationByAction(AbstractProject<?, ?> project, ConfigurationRotatorBuildAction action) throws IOException {
        this.acrs.setConfigurationByAction(project, action);
        this.reconfigure = true;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState arg4) throws IOException, InterruptedException {
        PrintStream out = listener.getLogger();
        if (project.isInQueue()) {
            out.println("A build already in queue - cancelling poll");
            logger.fine("A build already in queue - cancelling poll");
            return PollingResult.NO_CHANGES;
        }
        logger.fine("Version: " + Jenkins.getInstance().getPlugin(URL_NAME).getWrapper().getVersion());
        if (this.justConfigured) {
            this.reconfigure = this.acrs.wasReconfigured(project);
            logger.fine("Was reconfigured: " + this.reconfigure);
        }
        AbstractConfigurationRotatorSCM.Poller poller = this.acrs.getPoller(project, launcher, workspace, listener);
        ConfigurationRotatorBuildAction lastAction = this.acrs.getLastResult(project, null);
        try {
            if (this.reconfigure || lastAction == null) {
                logger.fine("Reconfigured, build now!");
                out.println("[ConfigRotator] Configuration from scratch, build now!");
                return PollingResult.BUILD_NOW;
            }
            logger.fine("Do actual polling");
            out.println("[ConfigRotator] Getting next configuration");
            return poller.poll(lastAction);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to poll", e);
            throw new AbortException(e.getMessage());
        }
    }

    public ChangeLogParser createChangeLogParser() {
        logger.fine("Creating change log parser");
        return this.acrs.createChangeLogParser();
    }

    static {
        VERSION = "Unresolved";
        try {
            if (Jenkins.getInstance() != null) {
                System.out.println("JENKINS" + Jenkins.getInstance());
                System.out.println("JENKINS" + Jenkins.getInstance().getRootDir());
                FEED_PATH = new File(Jenkins.getInstance().getRootDir(), FEED_DIR);
                VERSION = Jenkins.getInstance().getPlugin(URL_NAME).getWrapper().getVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Extension
    public static final class RotatorDescriptor
    extends SCMDescriptor<ConfigurationRotator> {
        public RotatorDescriptor() {
            super(ConfigurationRotator.class, null);
        }

        public String getDisplayName() {
            return "Config rotator";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ConfigurationRotator r = (ConfigurationRotator)super.newInstance(req, formData);
            ConfigurationRotatorSCMDescriptor d = (ConfigurationRotatorSCMDescriptor)r.getAcrs().getDescriptor();
            r.acrs = d.newInstance(req, formData, r.acrs);
            this.save();
            return r;
        }

        public List<ConfigurationRotatorSCMDescriptor<?>> getSCMs() {
            return AbstractConfigurationRotatorSCM.getDescriptors();
        }
    }

    public static enum ResultType {
        COMPATIBLE,
        INCOMPATIBLE,
        FAILED,
        UNDETERMINED;

    }
}

