/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.model.AbstractBuild;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;

public abstract class AbstractConfiguration<T extends AbstractConfigurationComponent>
implements Serializable {
    protected List<T> list = new ArrayList<T>();
    protected String description = null;

    public abstract List<ConfigRotatorChangeLogEntry> difference(T var1, T var2) throws ConfigurationRotatorException;

    public String getView(Class<?> clazz) {
        return clazz.getName().replace('.', '/').replace('$', '/') + "/" + "cr.jelly";
    }

    public AbstractConfigurationComponent getChangedComponent() {
        for (AbstractConfigurationComponent configuration : this.getList()) {
            if (!configuration.isChangedLast()) continue;
            return configuration;
        }
        return null;
    }

    public int getChangedComponentIndex() {
        int index = -1;
        for (AbstractConfigurationComponent configuration : this.getList()) {
            if (!configuration.isChangedLast()) continue;
            index = this.getList().indexOf(configuration);
        }
        return index;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.list + "]";
    }

    public List<T> getList() {
        return this.list;
    }

    public abstract <T extends AbstractConfiguration> T clone();

    public abstract String toHtml();

    public String getDescription(AbstractBuild<?, ?> build) {
        if (this.description == null) {
            ConfigurationRotator rotator = (ConfigurationRotator)build.getProject().getScm();
            if (this.getChangedComponent() == null) {
                return "New Configuration - no changes yet";
            }
            ConfigurationRotatorBuildAction previous = rotator.getAcrs().getPreviousResult(build, null);
            return String.format("%s<br/>%s", ((AbstractConfigurationComponent)previous.getConfigurationWithOutCast().getList().get(this.getChangedComponentIndex())).prettyPrint(), this.getChangedComponent().prettyPrint());
        }
        return this.description;
    }

    public String basicHtml(StringBuilder builder, String ... titles) {
        builder.append("<table style=\"text-align:left;border-solid:hidden;border-collapse:collapse;\">");
        builder.append("<thead>");
        for (String title : titles) {
            builder.append("<th style=\"padding-right:15px\">").append(title).append("</th>");
        }
        builder.append("</thead>");
        builder.append("<tbody>");
        for (AbstractConfigurationComponent comp : this.getList()) {
            builder.append(comp.toHtml());
        }
        builder.append("</tbody>");
        builder.append("</table>");
        return builder.toString();
    }
}

