/*
 * Decompiled with CFR 0.152.
 */
package me.leejay.jenkins.dateparameter;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.IOException;
import me.leejay.jenkins.dateparameter.StringLocalDateValue;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateParameterValue
extends StringParameterValue {
    private static final Logger log = LoggerFactory.getLogger(StringLocalDateValue.class);
    private static final long serialVersionUID = -3270996447541190520L;
    private final String value;
    private String dateFormat;

    @DataBoundConstructor
    public DateParameterValue(String name, String value, String description) {
        super(name, value, description);
        this.value = value;
    }

    public DateParameterValue(String name, String value, String dateFormat, String description) {
        this(name, value, description);
        this.dateFormat = dateFormat;
    }

    public void createValueFromDefault(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void createValueFromJenkins(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void createValueFromPostRequest(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getValue() {
        return this.value;
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String s) {
                return DateParameterValue.this.getValue();
            }
        };
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        super.buildEnvironment(build, env);
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (StringUtils.isEmpty((String)this.getValue())) {
            return null;
        }
        StringLocalDateValue value = new StringLocalDateValue(this.getValue(), this.getDateFormat());
        if (!value.isCompletionFormat()) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    throw new AbortException("Can't parse date format '" + DateParameterValue.this.getValue() + "' with '" + DateParameterValue.this.getDateFormat() + "'");
                }
            };
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateParameterValue that = (DateParameterValue)((Object)o);
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.dateFormat.equals(that.dateFormat);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.dateFormat.hashCode();
        return result;
    }
}

