/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.discardbuild;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.RunList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.discardbuild.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardBuildPublisher
extends Recorder {
    private final int daysToKeep;
    private final int numToKeep;
    private final Set<Result> resultsToDiscard;
    private final long minLogFileSize;
    private final long maxLogFileSize;
    private final int intervalDaysToKeep;
    private final int intervalNumToKeep;
    private final String regexp;

    @DataBoundConstructor
    public DiscardBuildPublisher(String daysToKeep, String intervalDaysToKeep, String numToKeep, String intervalNumToKeep, boolean discardSuccess, boolean discardUnstable, boolean discardFailure, boolean discardNotBuilt, boolean discardAborted, String minLogFileSize, String maxLogFileSize, String regexp) {
        this.daysToKeep = DiscardBuildPublisher.parse(daysToKeep);
        this.intervalDaysToKeep = DiscardBuildPublisher.parse(intervalDaysToKeep);
        this.numToKeep = DiscardBuildPublisher.parse(numToKeep);
        this.intervalNumToKeep = DiscardBuildPublisher.parse(intervalNumToKeep);
        this.resultsToDiscard = new HashSet<Result>();
        if (discardSuccess) {
            this.resultsToDiscard.add(Result.SUCCESS);
        }
        if (discardUnstable) {
            this.resultsToDiscard.add(Result.UNSTABLE);
        }
        if (discardFailure) {
            this.resultsToDiscard.add(Result.FAILURE);
        }
        if (discardNotBuilt) {
            this.resultsToDiscard.add(Result.NOT_BUILT);
        }
        if (discardAborted) {
            this.resultsToDiscard.add(Result.ABORTED);
        }
        this.minLogFileSize = DiscardBuildPublisher.parseLong(minLogFileSize);
        this.maxLogFileSize = DiscardBuildPublisher.parseLong(maxLogFileSize);
        this.regexp = regexp;
    }

    private static int parse(String p) {
        if (p == null) {
            return -1;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String p) {
        if (p == null) {
            return -1L;
        }
        try {
            return Long.parseLong(p);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static boolean isRegexpMatch(File logFile, String regexp) throws IOException, InterruptedException {
        String line;
        if (regexp == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regexp);
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private static String intToString(int i) {
        if (i == -1) {
            return "";
        }
        return Integer.toString(i);
    }

    private static String longToString(long i) {
        if (i == -1L) {
            return "";
        }
        return Long.toString(i);
    }

    private ArrayList<Run<?, ?>> keepLastBuilds(AbstractBuild<?, ?> build, BuildListener listener, RunList<Run<?, ?>> builds) {
        int lastUnsuccessfulBuild;
        int lastUnstableBuild;
        int lastSuccessfulBuild;
        int lastStableBuild;
        int lastFailedBuild;
        int lastCompletedBuild;
        int lastBuild;
        Job job = build.getParent();
        ExtendRunList newList = new ExtendRunList();
        try {
            lastBuild = job.getLastBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastBuild = -1;
        }
        try {
            lastCompletedBuild = job.getLastCompletedBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastCompletedBuild = -1;
        }
        try {
            lastFailedBuild = job.getLastFailedBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastFailedBuild = -1;
        }
        try {
            lastStableBuild = job.getLastStableBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastStableBuild = -1;
        }
        try {
            lastSuccessfulBuild = job.getLastSuccessfulBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastSuccessfulBuild = -1;
        }
        try {
            lastUnstableBuild = job.getLastUnstableBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastUnstableBuild = -1;
        }
        try {
            lastUnsuccessfulBuild = job.getLastSuccessfulBuild().getNumber();
        }
        catch (NullPointerException e) {
            lastUnsuccessfulBuild = -1;
        }
        for (Run r : builds) {
            int num = r.getNumber();
            if (lastBuild != -1 && num == lastBuild || lastCompletedBuild != -1 && num == lastCompletedBuild || lastFailedBuild != -1 && num == lastFailedBuild || lastStableBuild != -1 && num == lastStableBuild || lastSuccessfulBuild != -1 && num == lastSuccessfulBuild || lastUnstableBuild != -1 && num == lastUnstableBuild || lastUnsuccessfulBuild != -1 && num == lastUnsuccessfulBuild) continue;
            newList.add(r);
        }
        return newList.getNewList();
    }

    private void deleteOldBuildsByRegexp(AbstractBuild<?, ?> build, BuildListener listener, String regexp) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (regexp == null || regexp.equals("")) {
            return;
        }
        try {
            for (Run<?, ?> r : list) {
                if (!DiscardBuildPublisher.isRegexpMatch(r.getLogFile(), regexp)) continue;
                this.discardBuild(r, "match regular expression", listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void deleteOldBuildsByLogfileSize(AbstractBuild<?, ?> build, BuildListener listener, long minLogFileSize, long maxLogFileSize) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        try {
            if (minLogFileSize != -1L || maxLogFileSize != -1L) {
                for (Run<?, ?> r : list) {
                    long size = r.getLogFile().length();
                    if (minLogFileSize == -1L && size > maxLogFileSize) {
                        this.discardBuild(r, "log file size=" + size + " which is too big", listener);
                        continue;
                    }
                    if (maxLogFileSize == -1L && size < minLogFileSize) {
                        this.discardBuild(r, "log file size=" + size + " which is too small", listener);
                        continue;
                    }
                    if (minLogFileSize == -1L || maxLogFileSize == -1L || size >= minLogFileSize && size <= maxLogFileSize) continue;
                    this.discardBuild(r, "log file size=" + size + " which is too small or too big", listener);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteOldBuildsByDays(AbstractBuild<?, ?> build, BuildListener listener, int daysToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (daysToKeep == -1) {
            return;
        }
        try {
            Calendar cal = this.getCurrentCalendar();
            cal.add(6, -daysToKeep);
            for (Run<?, ?> r : list) {
                if (!r.getTimestamp().before(cal)) continue;
                this.discardBuild(r, "it is older than daysToKeep", listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByIntervalDays(AbstractBuild<?, ?> build, BuildListener listener, int intervalDaysToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (intervalDaysToKeep == -1) {
            return;
        }
        try {
            Run<?, ?> prev = null;
            for (Run<?, ?> r : list) {
                if (prev == null) {
                    prev = r;
                    continue;
                }
                Calendar prevCal = this.getCurrentCalendar();
                prevCal.setTime(prev.getTimestamp().getTime());
                prevCal.add(6, -intervalDaysToKeep);
                if (r.getTimestamp().after(prevCal)) {
                    this.discardBuild(r, "it is old and within build days interval", listener);
                    continue;
                }
                prev = r;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByNum(AbstractBuild<?, ?> build, BuildListener listener, int numToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (numToKeep == -1) {
            return;
        }
        int index = 0;
        try {
            for (Run<?, ?> r : list) {
                if (index >= numToKeep) {
                    this.discardBuild(r, "old than numToKeep", listener);
                }
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByIntervalNum(AbstractBuild<?, ?> build, BuildListener listener, int intervalNumToKeep) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        if (intervalNumToKeep == -1) {
            return;
        }
        int index = 0;
        try {
            if (intervalNumToKeep == 1) {
                intervalNumToKeep = 2;
            }
            for (Run<?, ?> r : list) {
                if (index % intervalNumToKeep != 0) {
                    this.discardBuild(r, "it is old and within build number interval", listener);
                }
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private void deleteOldBuildsByStatus(AbstractBuild<?, ?> build, BuildListener listener, Set<Result> resultsToDiscard) {
        ArrayList<Run<?, ?>> list = this.updateBuildsList(build, listener);
        try {
            for (Run<?, ?> r : list) {
                this.discardByStatus(r, resultsToDiscard, listener);
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(""));
        }
    }

    private ArrayList<Run<?, ?>> updateBuildsList(AbstractBuild<?, ?> build, BuildListener listener) {
        RunList builds = new RunList();
        ArrayList<Run<?, ?>> list = new ArrayList();
        Job job = build.getParent();
        builds = job.getBuilds();
        list = this.keepLastBuilds(build, listener, builds);
        return list;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println("Discard old builds...");
        this.deleteOldBuildsByDays(build, listener, this.daysToKeep);
        this.deleteOldBuildsByNum(build, listener, this.numToKeep);
        this.deleteOldBuildsByIntervalDays(build, listener, this.intervalDaysToKeep);
        this.deleteOldBuildsByIntervalNum(build, listener, this.intervalNumToKeep);
        this.deleteOldBuildsByStatus(build, listener, this.resultsToDiscard);
        this.deleteOldBuildsByLogfileSize(build, listener, this.minLogFileSize, this.maxLogFileSize);
        this.deleteOldBuildsByRegexp(build, listener, this.regexp);
        return true;
    }

    private boolean discardByStatus(Run<?, ?> history, Set<Result> resultSet, BuildListener listener) throws IOException {
        if (!resultSet.isEmpty() && resultSet.contains(history.getResult())) {
            this.discardBuild(history, String.format("status %s is not to be kept", history.getResult()), listener);
            return true;
        }
        return false;
    }

    private void discardBuild(Run<?, ?> history, String reason, BuildListener listener) throws IOException {
        listener.getLogger().printf("#%d is removed because %s\n", history.getNumber(), reason);
        history.delete();
    }

    public String getDaysToKeep() {
        return DiscardBuildPublisher.intToString(this.daysToKeep);
    }

    public String getNumToKeep() {
        return DiscardBuildPublisher.intToString(this.numToKeep);
    }

    public String getMinLogFileSize() {
        return DiscardBuildPublisher.longToString(this.minLogFileSize);
    }

    public String getMaxLogFileSize() {
        return DiscardBuildPublisher.longToString(this.maxLogFileSize);
    }

    public String getIntervalDaysToKeep() {
        return DiscardBuildPublisher.intToString(this.intervalDaysToKeep);
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getIntervalNumToKeep() {
        return DiscardBuildPublisher.intToString(this.intervalNumToKeep);
    }

    public boolean isDiscardSuccess() {
        return this.resultsToDiscard.contains(Result.SUCCESS);
    }

    public boolean isDiscardUnstable() {
        return this.resultsToDiscard.contains(Result.UNSTABLE);
    }

    public boolean isDiscardFailure() {
        return this.resultsToDiscard.contains(Result.FAILURE);
    }

    public boolean isDiscardNotBuilt() {
        return this.resultsToDiscard.contains(Result.NOT_BUILT);
    }

    public boolean isDiscardAborted() {
        return this.resultsToDiscard.contains(Result.ABORTED);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected Calendar getCurrentCalendar() {
        return Calendar.getInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DiscardHistoryBuilder_description();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtendRunList
    extends RunList<Run<?, ?>> {
        private ArrayList<Run<?, ?>> newList = new ArrayList();

        ExtendRunList() {
        }

        ArrayList<Run<?, ?>> getNewList() {
            return this.newList;
        }

        public boolean add(Run<?, ?> run) {
            this.newList.add(run);
            return true;
        }
    }
}

