/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class SystemGroovyChoiceListProvider
extends ChoiceListProvider {
    private static final long serialVersionUID = 3L;
    private static final String NoDefaultChoice = "###NODEFAULTCHOICE###";
    private static final Logger LOGGER = Logger.getLogger(SystemGroovyChoiceListProvider.class.getName());
    private transient String scriptText;
    private final SecureGroovyScript groovyScript;
    private final String defaultChoice;
    private final boolean usePredefinedVariables;
    private transient Job<?, ?> project;

    @Override
    public List<String> getChoiceList() {
        ArrayList ret = null;
        Job project = this.getProject();
        if (this.isUsePredefinedVariables() && project == null && Stapler.getCurrentRequest2() != null) {
            project = (Job)Stapler.getCurrentRequest2().findAncestorObject(Job.class);
        }
        try {
            ret = SystemGroovyChoiceListProvider.runScript(this.getGroovyScript(), this.isUsePredefinedVariables(), project);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to execute script", e);
        }
        return ret != null ? ret : new ArrayList(0);
    }

    private static List<String> runScript(SecureGroovyScript groovyScript, boolean usePredefinedVariables, Job<?, ?> project) throws Exception {
        Object out;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is unavailable.");
        }
        ClassLoader cl = jenkins.getPluginManager().uberClassLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Binding binding = new Binding();
        if (usePredefinedVariables) {
            if (project != null && project.hasPermission(Item.READ)) {
                binding.setVariable("project", project);
            } else {
                binding.setVariable("project", null);
            }
        }
        if ((out = groovyScript.evaluate(cl, binding)) == null) {
            return null;
        }
        if (!(out instanceof List)) {
            throw new IllegalArgumentException("Return type of the Groovy script must be List<String>");
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Object obj : (List)out) {
            if (obj == null) continue;
            ret.add(obj.toString());
        }
        return ret;
    }

    @Deprecated
    public String getScriptText() {
        return this.getGroovyScript().getScript();
    }

    public SecureGroovyScript getGroovyScript() {
        return this.groovyScript;
    }

    @Override
    public String getDefaultChoice() {
        return this.defaultChoice;
    }

    @DataBoundConstructor
    public SystemGroovyChoiceListProvider(SecureGroovyScript groovyScript, String defaultChoice, boolean usePredefinedVariables) {
        this.groovyScript = groovyScript.configuringWithNonKeyItem();
        this.defaultChoice = !NoDefaultChoice.equals(defaultChoice) ? defaultChoice : null;
        this.usePredefinedVariables = usePredefinedVariables;
    }

    public SystemGroovyChoiceListProvider(String scriptText, String defaultChoice, boolean usePredefinedVariables) {
        this(SystemGroovyChoiceListProvider.newSecureGroovyScript(scriptText), defaultChoice, usePredefinedVariables);
    }

    private static SecureGroovyScript newSecureGroovyScript(String scriptText) {
        try {
            return new SecureGroovyScript(scriptText, true, Collections.emptyList());
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    public SystemGroovyChoiceListProvider(String scriptText, String defaultChoice) {
        this(scriptText, defaultChoice, false);
    }

    private Object readResolve() {
        if (this.groovyScript != null) {
            return this;
        }
        return new SystemGroovyChoiceListProvider(this.scriptText, this.getDefaultChoice(), this.isUsePredefinedVariables());
    }

    public boolean isUsePredefinedVariables() {
        return this.usePredefinedVariables;
    }

    protected void setProject(Job<?, ?> project) {
        this.project = project;
    }

    @Deprecated
    protected void setProject(AbstractProject<?, ?> project) {
        this.setProject((Job<?, ?>)project);
    }

    protected Job<?, ?> getProject() {
        return this.project;
    }

    public static class ConverterImpl
    extends XStream2.PassthruConverter<SystemGroovyChoiceListProvider> {
        private final Mapper mapper;

        public ConverterImpl(XStream2 xstream) {
            super(xstream);
            this.mapper = xstream.getMapper();
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(source, writer, context);
            SystemGroovyChoiceListProvider src = (SystemGroovyChoiceListProvider)source;
            if (src.project != null) {
                writer.startNode("project");
                String attributeName = this.mapper.aliasForSystemAttribute("class");
                if (attributeName != null) {
                    writer.addAttribute(attributeName, this.mapper.serializedClass(src.project.getClass()));
                }
                context.convertAnother(src.project);
                writer.endNode();
            }
        }

        protected void callback(SystemGroovyChoiceListProvider obj, UnmarshallingContext context) {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ChoiceListProvider> {
        public SystemGroovyChoiceListProvider newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            SystemGroovyChoiceListProvider provider = (SystemGroovyChoiceListProvider)super.newInstance(req, formData);
            if (provider.isUsePredefinedVariables()) {
                provider.setProject((Job)req.findAncestorObject(Job.class));
            }
            return provider;
        }

        public String getDisplayName() {
            return Messages._SystemGroovyChoiceListProvider_DisplayName().toString();
        }

        @POST
        public ListBoxModel doFillDefaultChoiceItems(@AncestorInPath Job<?, ?> job, @RelativePath(value="groovyScript") @QueryParameter String script, @RelativePath(value="groovyScript") @QueryParameter boolean sandbox, @QueryParameter boolean usePredefinedVariables) {
            ListBoxModel ret = new ListBoxModel();
            ret.add(Messages.ExtensibleChoiceParameterDefinition_NoDefaultChoice(), SystemGroovyChoiceListProvider.NoDefaultChoice);
            if (job == null) {
                return ret;
            }
            job.checkPermission(Item.CONFIGURE);
            if (!sandbox) {
                return ret;
            }
            List<String> choices = null;
            Job<?, ?> project = null;
            if (usePredefinedVariables) {
                project = job;
            }
            try {
                choices = SystemGroovyChoiceListProvider.runScript(new SecureGroovyScript(script, sandbox, null).configuringWithNonKeyItem(), usePredefinedVariables, project);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to execute script", e);
            }
            if (choices != null) {
                for (String choice : choices) {
                    ret.add(choice);
                }
            }
            return ret;
        }

        public String getNoDefaultChoice() {
            return SystemGroovyChoiceListProvider.NoDefaultChoice;
        }

        @POST
        public FormValidation doTest(@AncestorInPath Job<?, ?> job, @RelativePath(value="groovyScript") @QueryParameter String script, @RelativePath(value="groovyScript") @QueryParameter boolean sandbox, @QueryParameter boolean usePredefinedVariables) {
            List<String> choices = null;
            Job<?, ?> project = null;
            if (job == null) {
                return FormValidation.warning((String)"You cannot evaluate scripts outside project configurations");
            }
            job.checkPermission(Item.CONFIGURE);
            if (!sandbox) {
                return FormValidation.warning((String)Messages.SystemGroovyChoiceListProvider_groovyScript_TestableOnlyWithSandbox());
            }
            if (usePredefinedVariables) {
                project = job;
            }
            try {
                choices = SystemGroovyChoiceListProvider.runScript(new SecureGroovyScript(script, sandbox, Collections.emptyList()).configuringWithNonKeyItem(), usePredefinedVariables, project);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Failed to execute script");
            }
            if (choices == null) {
                return FormValidation.error((String)"Script returned null.");
            }
            return FormValidation.ok((String)String.join((CharSequence)"\n", choices));
        }
    }
}

