/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.listeners.RunListener;
import java.util.List;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;

@Extension
public class ChoiceWatchRunListener
extends RunListener<AbstractBuild<?, ?>> {
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
    public void onFinalized(AbstractBuild<?, ?> build) {
        AbstractProject job = build.getProject();
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (pp == null) {
            return;
        }
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        if (action != null) {
            for (StringParameterValue value : Util.filter((List)action.getParameters(), StringParameterValue.class)) {
                ExtensibleChoiceParameterDefinition choiceDef;
                ParameterDefinition def = pp.getParameterDefinition(value.getName());
                if (def == null || !(def instanceof ExtensibleChoiceParameterDefinition) || (choiceDef = (ExtensibleChoiceParameterDefinition)def).getChoiceListProvider() == null) continue;
                choiceDef.getChoiceListProvider().onBuildCompletedWithValue(build, choiceDef, value.getValue().toString());
            }
        }
    }
}

