/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.xml;

import com.nirima.jenkins.xml.XmlSerializerException;
import com.nirima.jenkins.xml.impl.XMLOutputStreamWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlSerializerFactory {
    public static XMLOutputStreamWriter create() {
        return new XMLOutputStreamWriter();
    }

    public static XMLStreamWriter create(OutputStream os) throws XmlSerializerException {
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            xof.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            return xof.createXMLStreamWriter(os);
        }
        catch (XMLStreamException e) {
            throw new XmlSerializerException("Problem Creating a pull parser", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream is) throws XmlSerializerException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", "true");
            XMLStreamReader parser = factory.createXMLStreamReader(is);
            return parser;
        }
        catch (XMLStreamException e) {
            throw new XmlSerializerException("Problem Creating a pull parser", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) throws XmlSerializerException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            XMLStreamReader parser = factory.createXMLStreamReader(reader);
            return parser;
        }
        catch (XMLStreamException e) {
            throw new XmlSerializerException("Problem Creating a pull parser reader", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(String xml) throws XmlSerializerException {
        StringReader sr = new StringReader(xml);
        return XmlSerializerFactory.createXMLStreamReader(sr);
    }

    static {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        System.setProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.evt.WstxEventFactory");
    }
}

