/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl.methods;

import com.nirima.jenkins.webdav.impl.methods.MethodBase;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.MethodException;
import java.net.URLDecoder;

public class Move
extends MethodBase {
    @Override
    public void invoke(IDavContext ctxt) throws MethodException {
        try {
            String destination;
            IDavRepo repo = this.getRepo();
            IDavItem sourceItem = repo.getItem(this.getDavContext(), this.getPath());
            if (sourceItem != null && (destination = URLDecoder.decode(this.getRequest().getHeader("Destination"), "UTF-8")).startsWith(this.getBaseUrl())) {
                destination = destination.substring(this.getBaseUrl().length());
                IDavItem destinationItem = null;
                try {
                    destinationItem = repo.getItem(this.getDavContext(), destination);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (destinationItem != null) {
                    this.getResponse().setStatus(412);
                    return;
                }
                int lastSlash = destination.lastIndexOf("/");
                if (lastSlash != -1) {
                    String newFilename = destination.substring(lastSlash + 1);
                    String destParentPath = "";
                    if (lastSlash > 0) {
                        destParentPath = destination.substring(0, lastSlash);
                    }
                    if (destParentPath.equalsIgnoreCase(sourceItem.getParentPath(ctxt))) {
                        sourceItem.rename(ctxt, newFilename);
                        this.getResponse().setStatus(201);
                        return;
                    }
                }
            }
            this.getResponse().setStatus(409);
        }
        catch (Exception e) {
            throw new MethodException("Error putting object", e);
        }
    }
}

