/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl.methods;

import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.IMethod;
import com.nirima.jenkins.webdav.interfaces.MethodException;
import com.nirima.jenkins.xml.XmlSerializerException;
import com.nirima.jenkins.xml.XmlSerializerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodBase
implements IMethod {
    private static Logger s_logger = LoggerFactory.getLogger(MethodBase.class);
    protected static String s_dateFormat = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;
    private String m_path;
    private String m_baseUrl;
    private IDavRepo m_repo;
    private IDavContext m_ctx;

    protected IDavContext getDavContext() {
        return this.m_ctx;
    }

    @Override
    public void invoke() throws MethodException {
        this.invoke(this.m_ctx);
    }

    public void invoke(IDavContext ctxt) throws MethodException {
        s_logger.info("base:invoke Called");
    }

    protected IDavRepo getRepo() throws MethodException {
        return this.m_repo;
    }

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response, IDavContext ctx, IDavRepo repo, String root) {
        this.m_request = request;
        this.m_response = response;
        this.m_ctx = ctx;
        this.m_repo = repo;
        this.m_baseUrl = "http://" + request.getServerName();
        if (request.getServerPort() != 80) {
            this.m_baseUrl = this.m_baseUrl + ":" + request.getServerPort();
        }
        this.m_baseUrl = this.m_baseUrl + request.getContextPath() + request.getServletPath();
        this.m_baseUrl = this.m_baseUrl + root;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = request.getServletPath();
        }
        this.m_path = request.getContextPath() + pathInfo;
        this.m_path = this.m_path == null ? "/" : this.m_path.substring(root.length());
        s_logger.info(request.getMethod() + " " + this.m_baseUrl + " Called with path " + this.m_path);
    }

    protected XMLStreamWriter createXmlResponse() {
        try {
            ServletOutputStream os = this.m_response.getOutputStream();
            XMLStreamWriter serializer = XmlSerializerFactory.create((OutputStream)os);
            return serializer;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating xml response", e);
        }
    }

    protected XMLStreamReader getDocument() throws MethodException, XmlSerializerException, IOException {
        s_logger.info("Request length = " + this.m_request.getContentLength());
        if (this.m_request.getContentLength() == 0) {
            return null;
        }
        BufferedReader r = this.m_request.getReader();
        XMLStreamReader xpp = XmlSerializerFactory.createXMLStreamReader(r);
        return xpp;
    }

    protected boolean suppliedHeader(String name) {
        String header = this.m_request.getHeader(name);
        return header != null && header.length() > 0;
    }

    protected String getHeader(String name) {
        return this.m_request.getHeader(name);
    }

    protected void addHeader(String name, String value) {
        this.m_response.addHeader(name, value);
    }

    protected int getHeaderInt(String name, int defaultValue) {
        String header = this.m_request.getHeader(name);
        try {
            if (header != null && header.length() > 0) {
                return Integer.parseInt(header);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    protected int getHeaderTime(String name, int defaultValue) {
        String header = this.m_request.getHeader(name);
        if (header == null || !header.startsWith("Second-")) {
            return defaultValue;
        }
        try {
            int idx = header.indexOf(" ");
            header = idx != -1 ? header.substring(7, idx) : header.substring(7);
            return Integer.parseInt(header);
        }
        catch (Exception e) {
            s_logger.warn("Failed to parse " + name + " as a time");
            return defaultValue;
        }
    }

    protected Date getHeaderDate(String name) {
        String header = this.m_request.getHeader(name);
        if (header == null || header.length() == 0) {
            return null;
        }
        try {
            return new SimpleDateFormat(s_dateFormat).parse(header);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ArrayList<String> getETags(String name) {
        String value = this.m_request.getHeader(name);
        ArrayList<String> list = new ArrayList<String>();
        if (value == null) {
            return list;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    protected String getLockToken() throws MethodException {
        String strLockToken = null;
        String strIf = this.m_request.getHeader("Lock-Token");
        s_logger.info("Lock token Header: " + strIf);
        if (strIf != null && strIf.length() > 0) {
            strLockToken = strIf.substring("opaquelocktoken:".length() + 1, strIf.lastIndexOf(">"));
        }
        s_logger.info("Lock token Header = " + strLockToken + ".");
        return strLockToken;
    }

    protected String parseIfHeader() throws MethodException {
        String strLockToken = null;
        String strIf = this.m_request.getHeader("If");
        s_logger.info("Lock token Header: " + strIf);
        if (strIf != null && strIf.length() > 0) {
            if (strIf.startsWith("(<")) {
                int idx = strIf.indexOf(">");
                if (idx != -1) {
                    try {
                        strLockToken = strIf.substring("opaquelocktoken:".length() + 2, idx);
                    }
                    catch (IndexOutOfBoundsException e) {
                        s_logger.warn("Failed to parse If header: " + strIf);
                    }
                } else {
                    this.m_response.setStatus(400);
                    throw new MethodException("Bad Request");
                }
                if (strIf.length() > idx + 2) {
                    s_logger.warn("The If header contained more than one lock token, only one is supported");
                }
            } else if (strIf.startsWith("<")) {
                s_logger.warn("Tagged lists in the If header are not supported");
            } else if (strIf.startsWith("([")) {
                s_logger.warn("ETags in the If header are not supported");
            }
        }
        return strLockToken;
    }

    protected String getBaseUrl() {
        return this.m_baseUrl;
    }

    protected String getPath() {
        return this.m_path;
    }

    protected String getUrl() {
        return this.m_baseUrl + this.m_path;
    }

    protected HttpServletRequest getRequest() {
        return this.m_request;
    }

    protected HttpServletResponse getResponse() {
        return this.m_response;
    }
}

