/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.update;

import com.google.common.base.Objects;
import hudson.maven.reporters.MavenArtifact;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryArtifactRecord
implements Serializable {
    public List<MavenArtifact> attachedArtifacts = new ArrayList<MavenArtifact>();
    public MavenArtifact mainArtifact;
    public MavenArtifact pomArtifact;
    public String repositoryUrl;
    public String repositoryId;
    public Map<MavenArtifact, File> fileMap = new HashMap<MavenArtifact, File>();

    public static RepositoryArtifactRecord parse(BufferedReader br) throws IOException {
        String line;
        RepositoryArtifactRecord record = new RepositoryArtifactRecord();
        while ((line = br.readLine()) != null) {
            if (line.equals("[pom]")) {
                record.pomArtifact = record.parseArtifact(br).get(0);
                continue;
            }
            if (line.equals("[main]")) {
                List<MavenArtifact> artifacts = record.parseArtifact(br);
                record.mainArtifact = artifacts.get(0);
                for (int i = 1; i < artifacts.size(); ++i) {
                    record.attachedArtifacts.add(artifacts.get(i));
                }
                continue;
            }
            if (line.equals("[attached]") || line.equals("[artifact]")) {
                record.attachedArtifacts.addAll(record.parseArtifact(br));
                continue;
            }
            if (line.equals("[repositoryUrl]")) {
                record.repositoryUrl = br.readLine();
                continue;
            }
            if (line.equals("[repositoryId]")) {
                record.repositoryId = br.readLine();
                continue;
            }
            System.out.println("Unexpected line: " + line);
        }
        return record;
    }

    private RepositoryArtifactRecord() {
    }

    private List<MavenArtifact> parseArtifact(BufferedReader br) throws IOException {
        String fileType;
        String file = br.readLine();
        String groupId = br.readLine();
        String artifactId = br.readLine();
        String version = br.readLine();
        String classifier = br.readLine();
        String type = br.readLine();
        String fileName = br.readLine();
        String md5sum = br.readLine();
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        MavenArtifact a = new MavenArtifact(groupId, artifactId, version, classifier, type, fileName, md5sum);
        this.fileMap.put(a, new File(file));
        result.add(a);
        int idx = fileName.lastIndexOf(46);
        if (idx > -1 && !(fileType = fileName.substring(idx + 1)).equals(type)) {
            MavenArtifact b = new MavenArtifact(groupId, artifactId, version, classifier, fileType, fileName, md5sum);
            this.fileMap.put(b, new File(file));
            result.add(b);
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("attachedArtifacts", this.attachedArtifacts).add("mainArtifact", (Object)this.mainArtifact).add("pomArtifact", (Object)this.pomArtifact).add("repositoryUrl", (Object)this.repositoryUrl).add("repositoryId", (Object)this.repositoryId).add("fileMap", this.fileMap).toString();
    }
}

