/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.update;

import hudson.model.Job;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;

public class ProjectReference
implements Serializable {
    public final String project;
    public final String buildNumber;

    private ProjectReference(String project, String buildNumber) {
        this.project = project;
        this.buildNumber = buildNumber;
    }

    public static ProjectReference read(BufferedReader br) throws IOException {
        String project = br.readLine();
        String buildNumber = br.readLine();
        return new ProjectReference(project, buildNumber);
    }

    public Run getBuild() {
        return this.getBuild(this.project, this.buildNumber);
    }

    private Run getBuild(String project, String buildNumber) {
        if (project.indexOf(32) > 0) {
            String[] elements = project.split(" ");
            if (elements.length == 2) {
                return this.getMultiBranchProject(elements[0], elements[1], Integer.parseInt(buildNumber));
            }
            if (elements.length == 3) {
                return this.getMultiBranchProject(elements[1], elements[2], Integer.parseInt(buildNumber));
            }
        }
        Run build = null;
        for (Job j : Jenkins.getInstance().getAllItems(Job.class)) {
            if (!j.getName().equals(project)) continue;
            build = j.getBuildByNumber(Integer.parseInt(buildNumber));
        }
        return build;
    }

    private Run getMultiBranchProject(String element, String job, int buildNumber) {
        for (MultiBranchProject j : Jenkins.getInstance().getAllItems(MultiBranchProject.class)) {
            if (!j.getName().equals(element)) continue;
            for (Object j2 : j.getAllJobs()) {
                if (!((Job)j2).getName().equals(job)) continue;
                return ((Job)j2).getBuildByNumber(buildNumber);
            }
        }
        return null;
    }
}

