/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.action.ProjectRepositoryAction;
import com.nirima.jenkins.action.RepositoryAction;
import com.nirima.jenkins.repo.util.HudsonVisitor;
import com.nirima.jenkins.update.RepositoryArtifactRecord;
import com.nirima.jenkins.update.RepositoryArtifactRecords;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.util.RunList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudsonWalker {
    private static final Logger log = LoggerFactory.getLogger(HudsonWalker.class);

    public static void traverse(HudsonVisitor visitor) {
        for (BuildableItemWithBuildWrappers item : Hudson.getInstance().getAllItems(BuildableItemWithBuildWrappers.class)) {
            visitor.visitProject(item);
            RunList runs = item.asProject().getBuilds();
            for (Run run : runs) {
                HudsonWalker.traverse(visitor, run);
            }
        }
    }

    public static void traverseProjectsAndBuilds(HudsonVisitor visitor) {
        for (BuildableItemWithBuildWrappers item : Hudson.getInstance().getAllItems(BuildableItemWithBuildWrappers.class)) {
            visitor.visitProject(item);
            RunList runs = item.asProject().getBuilds();
            for (Run run : runs) {
                if (!(run instanceof MavenModuleSetBuild)) continue;
                MavenModuleSetBuild mmsb = (MavenModuleSetBuild)run;
                visitor.visitModuleSet(mmsb);
            }
        }
    }

    public static void traverseChain(HudsonVisitor visitor, Run run) {
        if (run == null) {
            return;
        }
        HudsonWalker.traverse(visitor, run);
        RepositoryAction repositoryAction = (RepositoryAction)run.getAction(RepositoryAction.class);
        if (repositoryAction != null && repositoryAction instanceof ProjectRepositoryAction) {
            final ProjectRepositoryAction projectRepositoryAction = (ProjectRepositoryAction)repositoryAction;
            AbstractProject item = (AbstractProject)Hudson.getInstance().getItem(projectRepositoryAction.getProjectName());
            Optional r = Iterables.tryFind((Iterable)item.getBuilds(), (Predicate)new Predicate<Run>(){

                public boolean apply(Run run) {
                    return run.getNumber() == projectRepositoryAction.getBuildNumber();
                }
            });
            if (r.isPresent()) {
                HudsonWalker.traverseChain(visitor, (Run)r.get());
            }
        }
    }

    public static void traverse(HudsonVisitor visitor, Run run) {
        block4: {
            block3: {
                if (!(run instanceof MavenModuleSetBuild)) break block3;
                MavenModuleSetBuild item = (MavenModuleSetBuild)run;
                visitor.visitModuleSet(item);
                Map modulesMap = item.getModuleBuilds();
                for (List builds : modulesMap.values()) {
                    for (MavenBuild build : builds) {
                        log.trace("Visit mavenBuild {}", (Object)build);
                        visitor.visitBuild((AbstractBuild)build);
                        MavenArtifactRecord artifacts = (MavenArtifactRecord)build.getAction(MavenArtifactRecord.class);
                        if (artifacts == null) continue;
                        HudsonWalker.visitMavenArtifactRecord(visitor, (Run)build, artifacts);
                    }
                }
                break block4;
            }
            RepositoryArtifactRecords records = (RepositoryArtifactRecords)run.getAction(RepositoryArtifactRecords.class);
            if (records == null) break block4;
            for (RepositoryArtifactRecord record : records.recordList) {
                HudsonWalker.visitRepositoryRecord(visitor, run, record);
            }
        }
    }

    private static void visitRepositoryRecord(HudsonVisitor visitor, Run build, RepositoryArtifactRecord artifacts) {
        log.trace("Visit Build {} artifacts {}", (Object)build, (Object)artifacts);
        try {
            visitor.visitArtifact(build, artifacts.pomArtifact);
            if (artifacts.mainArtifact != artifacts.pomArtifact) {
                visitor.visitArtifact(build, artifacts.mainArtifact);
            }
            for (MavenArtifact art : artifacts.attachedArtifacts) {
                visitor.visitArtifact(build, art);
            }
        }
        catch (Exception ex) {
            log.error("Error fetching artifact details");
            log.error("Error", (Throwable)ex);
        }
    }

    private static void visitMavenArtifactRecord(HudsonVisitor visitor, Run build, MavenArtifactRecord artifacts) {
        log.trace("Visit Build {} artifacts {}", (Object)build, (Object)artifacts);
        try {
            visitor.visitArtifact(build, artifacts.pomArtifact);
            if (artifacts.mainArtifact != artifacts.pomArtifact) {
                visitor.visitArtifact(build, artifacts.mainArtifact);
            }
            for (MavenArtifact art : artifacts.attachedArtifacts) {
                visitor.visitArtifact(build, art);
            }
        }
        catch (Exception ex) {
            log.error("Error fetching artifact details");
            log.error("Error", (Throwable)ex);
        }
    }
}

