/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.project.ProjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.BuildableItem;
import hudson.model.Hudson;
import java.util.Collection;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;

public class ProjectsElement
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    public ProjectsElement(RepositoryDirectory parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "project";
    }

    @NonNull
    public Collection<RepositoryElement> getChildren() {
        return ProjectUtils.getChildren(this, Collections2.filter((Collection)Jenkins.getInstance().getAllItems(BuildableItem.class), (Predicate)new Predicate<BuildableItem>(){

            public boolean apply(@Nullable BuildableItem input) {
                if (input == null) {
                    return false;
                }
                if (input.getParent() instanceof Hudson) {
                    return true;
                }
                return input.getParent() instanceof OrganizationFolder;
            }
        }));
    }

    @Override
    public RepositoryElement getChild(String element) {
        for (RepositoryElement e : this.getChildren()) {
            if (!e.getName().equals(element)) continue;
            return e;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "ProjectsElement{}";
    }
}

