/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.project.MultiBranchProjectElement;
import com.nirima.jenkins.repo.project.ProjectElement;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jenkins.branch.MultiBranchProject;

public class ProjectUtils {
    public static Collection<RepositoryElement> getChildren(final RepositoryDirectory parent, Collection<?> items) {
        ArrayList elements = Lists.newArrayList((Iterator)Iterators.transform(items.iterator(), (Function)new Function<Object, RepositoryElement>(){

            public RepositoryElement apply(Object from) {
                if (from instanceof BuildableItemWithBuildWrappers) {
                    return new ProjectElement(parent, (Job)((BuildableItemWithBuildWrappers)from).asProject());
                }
                if (from instanceof MultiBranchProject) {
                    return new MultiBranchProjectElement(parent, (MultiBranchProject)from);
                }
                if (from instanceof Job) {
                    return new ProjectElement(parent, (Job)from);
                }
                return null;
            }
        }));
        return Collections2.filter((Collection)elements, (Predicate)new Predicate<RepositoryElement>(){

            public boolean apply(RepositoryElement input) {
                return input != null;
            }
        });
    }

    public static String sanitizeName(String name) {
        return name.replace("/", "-").replace("%2F", "-");
    }
}

