/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.google.common.collect.Lists;
import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.build.ProjectBuildRepositoryRoot;
import com.nirima.jenkins.repo.project.ProjectBuildList;
import com.nirima.jenkins.repo.project.ProjectUtils;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;

public class ProjectElement
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    Job item;

    public ProjectElement(RepositoryDirectory parent, Job project) {
        super(parent);
        if (project == null) {
            throw new IllegalArgumentException("project must not be null");
        }
        this.item = project;
    }

    @Override
    public Collection<? extends RepositoryElement> getChildren() {
        ArrayList ar = Lists.newArrayList((Object[])new ProjectBuildList[]{new ProjectBuildList(this, this.item, ProjectBuildList.Type.SHA1), new ProjectBuildList(this, this.item, ProjectBuildList.Type.Build)});
        if (this.item.getLastSuccessfulBuild() != null) {
            ar.add(new ProjectBuildRepositoryRoot(this, this.item.getLastSuccessfulBuild(), "LastSuccessful"));
        }
        return ar;
    }

    @Override
    public String getName() {
        return ProjectUtils.sanitizeName(this.item.getName());
    }

    @Override
    public String getDescription() {
        return "Project " + this.getName();
    }

    public String toString() {
        return "ProjectElement{" + this.getName() + "}";
    }
}

