/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.ProjectBuildRepositoryRoot;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.util.BuildData;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectBuildList
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    private static Logger log = LoggerFactory.getLogger(ProjectBuildList.class);
    Type type;
    Job item;

    protected ProjectBuildList(RepositoryDirectory parent, Job item, Type type) {
        super(parent);
        this.type = type;
        this.item = item;
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    private Job<?, ?> getJob() {
        return this.item;
    }

    public Collection<ProjectBuildRepositoryRoot> getChildren() {
        if (this.type == Type.Build) {
            Function<Run, ProjectBuildRepositoryRoot> fn = new Function<Run, ProjectBuildRepositoryRoot>(){

                public ProjectBuildRepositoryRoot apply(Run r) {
                    return new ProjectBuildRepositoryRoot(ProjectBuildList.this, r, "" + r.getNumber());
                }
            };
            Iterable i = Iterables.transform((Iterable)this.getJob().getBuilds(), (Function)fn);
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)i, (Predicate)new Predicate<ProjectBuildRepositoryRoot>(){

                public boolean apply(ProjectBuildRepositoryRoot projectBuildRepositoryRoot) {
                    return projectBuildRepositoryRoot != null;
                }
            }));
        }
        HashMap<String, ProjectBuildRepositoryRoot> children = new HashMap<String, ProjectBuildRepositoryRoot>();
        log.info("Getting builds from {}", (Object)this.item);
        for (Run run : this.getJob().getBuilds()) {
            try {
                String sha1;
                BuildData bd = (BuildData)run.getAction(BuildData.class);
                if (bd == null || run.getResult() != Result.SUCCESS || children.containsKey(sha1 = bd.getLastBuiltRevision().getSha1String()) || !run.getResult().isBetterOrEqualTo(Result.SUCCESS)) continue;
                children.put(sha1, new ProjectBuildRepositoryRoot(this, run, sha1));
            }
            catch (Exception ex) {
                log.error("Error processing {}", (Object)run);
                log.error("Error", (Throwable)ex);
            }
        }
        return children.values();
    }

    public static enum Type {
        SHA1,
        Build;

    }
}

