/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.project.ProjectUtils;
import java.util.Collection;
import jenkins.branch.MultiBranchProject;

public class MultiBranchProjectElement
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    MultiBranchProject item;

    public MultiBranchProjectElement(RepositoryDirectory parent, MultiBranchProject project) {
        super(parent);
        if (project == null) {
            throw new IllegalArgumentException("project must not be null");
        }
        this.item = project;
    }

    @Override
    public Collection<? extends RepositoryElement> getChildren() {
        Collection jobs = this.item.getAllJobs();
        return ProjectUtils.getChildren(this, jobs);
    }

    @Override
    public String getName() {
        return ProjectUtils.sanitizeName(this.item.getName());
    }

    @Override
    public String getDescription() {
        return "Project " + this.getName();
    }

    public String toString() {
        return "ProjectElement{" + this.getName() + "}";
    }
}

