/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.fs;

import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.DirectoryRepositoryItem;
import com.nirima.jenkins.repo.build.PopulateOnDemandDirectoryRepositoryItem;
import com.nirima.jenkins.repo.fs.FileRepositoryItem;
import com.nirima.jenkins.repo.util.IDirectoryPopulator;
import java.io.File;

public class FileDirectoryRepositoryItem
extends PopulateOnDemandDirectoryRepositoryItem
implements RepositoryDirectory {
    private File item;

    public FileDirectoryRepositoryItem(RepositoryDirectory parent, File item) {
        super(parent, item.getName());
        this.item = item;
    }

    @Override
    protected IDirectoryPopulator getPopulator() {
        return new IDirectoryPopulator(){

            @Override
            public void populate(DirectoryRepositoryItem directory) {
                File[] listFiles = FileDirectoryRepositoryItem.this.item.listFiles();
                if (listFiles == null) {
                    return;
                }
                for (File child : listFiles) {
                    if (child.isDirectory()) {
                        FileDirectoryRepositoryItem.this.add(new FileDirectoryRepositoryItem((RepositoryDirectory)FileDirectoryRepositoryItem.this, child), false);
                        continue;
                    }
                    FileDirectoryRepositoryItem.this.add(new FileRepositoryItem(FileDirectoryRepositoryItem.this, child), false);
                }
            }
        };
    }

    @Override
    public String toString() {
        String str = "";
        if (this.parent != null) {
            str = str + this.parent.toString();
        }
        str = str + this.item.getName();
        return str;
    }
}

