/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.google.common.collect.Lists;
import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.build.DirectoryRepositoryItem;
import com.nirima.jenkins.repo.build.SimpleOnDemandItem;
import com.nirima.jenkins.repo.util.DirectoryPopulatorVisitor;
import com.nirima.jenkins.repo.util.HudsonWalker;
import com.nirima.jenkins.repo.util.IDirectoryPopulator;
import hudson.model.Run;
import java.util.Collection;

public class ProjectBuildRepositoryRoot
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    private final String name;
    protected final Run item;

    public ProjectBuildRepositoryRoot(RepositoryDirectory parent, Run item, String name) {
        super(parent);
        if (item == null || name == null) {
            throw new IllegalArgumentException("Must specify run and name");
        }
        this.name = name;
        this.item = item;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<? extends RepositoryElement> getChildren() {
        return Lists.newArrayList((Object[])new SimpleOnDemandItem[]{new SimpleOnDemandItem(this, "repository", new IDirectoryPopulator(){

            @Override
            public void populate(DirectoryRepositoryItem directory) {
                HudsonWalker.traverse(new DirectoryPopulatorVisitor(directory, false), ProjectBuildRepositoryRoot.this.item);
            }
        }), new SimpleOnDemandItem(this, "repositoryChain", new IDirectoryPopulator(){

            @Override
            public void populate(DirectoryRepositoryItem directory) {
                HudsonWalker.traverseChain(new DirectoryPopulatorVisitor(directory, false), ProjectBuildRepositoryRoot.this.item);
            }
        })});
    }

    @Override
    public String getDescription() {
        return this.item.toString();
    }

    public String toString() {
        return "ProjectBuildRepositoryRoot{" + this.name + "," + this.item.toString() + "}";
    }
}

