/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.build.TextRepositoryItem;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class MetadataChecksumRepositoryItem
extends TextRepositoryItem {
    private String algorithm;
    private RepositoryContent item;

    public MetadataChecksumRepositoryItem(String algorithm, RepositoryContent item) {
        this.algorithm = algorithm;
        this.item = item;
    }

    @Override
    public String getName() {
        return this.item.getName() + "." + this.algorithm.toLowerCase();
    }

    @Override
    public Date getLastModified() {
        return this.item.getLastModified();
    }

    @Override
    public String getDescription() {
        return this.item.getDescription();
    }

    @Override
    protected String generateContent() {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm.toUpperCase());
            byte[] digest = md.digest(IOUtils.toByteArray((InputStream)this.item.getContent()));
            String hex = new BigInteger(1, digest).toString(16);
            int requiredNumberOfCharacters = md.getDigestLength() * 2;
            while (hex.length() < requiredNumberOfCharacters) {
                hex = "0" + hex;
            }
            return hex;
        }
        catch (Exception nsae) {
            return "ERROR: " + nsae.getMessage();
        }
    }
}

