/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.RepositoryPlugin;
import com.nirima.jenkins.repo.AbstractRepositoryElement;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryRepositoryItem
extends AbstractRepositoryElement
implements RepositoryDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RepositoryPlugin.class.getName());
    protected Map<String, RepositoryElement> items;
    protected String name;
    protected String description;

    public DirectoryRepositoryItem(RepositoryDirectory parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected Map<String, RepositoryElement> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, RepositoryElement>();
        }
        return this.items;
    }

    @Override
    public Collection<? extends RepositoryElement> getChildren() {
        return this.getItems().values();
    }

    public void insert(RepositoryContent content, String path, boolean allowOverwrite) {
        if (path.contains("/")) {
            int idx = path.indexOf("/");
            String dir = path.substring(0, idx);
            String rest = path.substring(idx + 1);
            RepositoryElement dirElement = this.getChild(dir);
            if (dirElement == null) {
                dirElement = this.add(new DirectoryRepositoryItem(this, dir), allowOverwrite);
            }
            ((DirectoryRepositoryItem)dirElement).insert(content, rest, allowOverwrite);
        } else {
            this.add(content, allowOverwrite);
        }
    }

    protected RepositoryElement add(RepositoryElement dirElement, boolean allowOverwrite) {
        if (this.getItems().containsKey(dirElement.getName()) && !allowOverwrite) {
            return this.items.get(dirElement.getName());
        }
        this.getItems().put(dirElement.getName(), dirElement);
        dirElement.setParent(this);
        return dirElement;
    }

    @Override
    public RepositoryElement getChild(String element) {
        return this.getItems().get(element);
    }

    public String toString() {
        String str = "";
        if (this.parent != null) {
            str = str + this.parent.toString();
        }
        str = str + "\\";
        str = str + this.name;
        return str;
    }
}

