/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.MetadataRepositoryItem;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.model.Run;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;

public class ArtifactRepositoryItem
implements RepositoryContent {
    private MavenArtifact artifact;
    private Run<?, ?> build;
    private boolean timestampedSnapshot;
    private RepositoryDirectory directory;

    public ArtifactRepositoryItem(Run<?, ?> build, MavenArtifact mavenArtifact, boolean timestampedSnapshot) {
        this.artifact = mavenArtifact;
        this.build = build;
        this.timestampedSnapshot = timestampedSnapshot;
    }

    @Override
    public String getName() {
        if (this.timestampedSnapshot && this.artifact.version.endsWith("-SNAPSHOT")) {
            String vers = MetadataRepositoryItem.formatDateVersion(this.build);
            return this.artifact.canonicalName.replaceAll("SNAPSHOT", vers);
        }
        return this.artifact.canonicalName;
    }

    @Override
    public RepositoryDirectory getParent() {
        return this.directory;
    }

    @Override
    public void setParent(RepositoryDirectory parent) {
        this.directory = parent;
    }

    @Override
    public String getPath() {
        return this.directory.getPath() + "/" + this.getName();
    }

    @Override
    public InputStream getContent() throws Exception {
        return new FileInputStream(this.getFile());
    }

    @Override
    public Date getLastModified() {
        return new Date(this.getFile().lastModified());
    }

    @Override
    public Long getSize() {
        return this.getFile().length();
    }

    @Override
    public String getDescription() {
        if (this.build instanceof MavenBuild) {
            return "From Build #" + this.build.getNumber() + " of " + ((MavenBuild)this.build).getParentBuild().getParent().getName();
        }
        return "From Build #" + this.build.getNumber() + " of " + this.build.getDisplayName();
    }

    public boolean fileExists() {
        try {
            this.getFile();
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    public File getFile() {
        File fPath = new File(new File(new File(this.build.getArtifactsDir(), this.artifact.groupId), this.artifact.artifactId), this.artifact.version);
        File fArtifact = new File(fPath, this.artifact.canonicalName);
        if (fArtifact.exists()) {
            return fArtifact;
        }
        fArtifact = new File(fPath, this.artifact.fileName);
        if (fArtifact.exists()) {
            return fArtifact;
        }
        throw new IllegalStateException("Maven artifact cannot be found with name or canonicalName - " + this.artifact);
    }

    public String getArtifactPath() {
        return this.artifact.groupId.replace('.', '/') + "/" + this.artifact.artifactId + '/' + this.artifact.version + "/" + this.getName();
    }

    @Override
    public String getContentType() {
        if (this.artifact.isPOM()) {
            return "application/xml";
        }
        if (this.artifact.type.equalsIgnoreCase("jar")) {
            return "application/java-archive";
        }
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }
}

