/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.bridge;

import com.nirima.jenkins.bridge.BridgeRepositoryContent;
import com.nirima.jenkins.bridge.BridgeRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.RootElement;
import com.nirima.jenkins.webdav.interfaces.IDavCollection;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.IMimeTypeResolver;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeRepository
implements IDavRepo {
    private static final Logger log = LoggerFactory.getLogger(BridgeRepository.class);
    IMimeTypeResolver mimeTypeResolver;
    final RepositoryDirectory rootElement;

    public BridgeRepository(IMimeTypeResolver mimeTypeResolver) {
        this(new RootElement(), mimeTypeResolver);
    }

    public BridgeRepository(RepositoryDirectory root, IMimeTypeResolver mimeTypeResolver) {
        if (root == null) {
            throw new IllegalArgumentException("BridgeRepository must have a root");
        }
        this.rootElement = root;
        this.mimeTypeResolver = mimeTypeResolver;
    }

    @Override
    public IDavItem getItem(IDavContext ctxt, String path) {
        try {
            RepositoryElement currentItem = this.rootElement;
            String[] pathElements = path.substring(1).split("/");
            if (pathElements.length > 1 || pathElements[0].length() > 0) {
                for (String element : pathElements) {
                    RepositoryDirectory currentDirectory;
                    log.trace("Found element {}", (Object)element);
                    if (!(currentItem instanceof RepositoryDirectory) || (currentItem = (currentDirectory = currentItem).getChild(element)) != null) continue;
                    log.error("Could not find item {} in element {}", (Object)element, (Object)currentDirectory);
                    return null;
                }
            }
            return this.bridge(currentItem);
        }
        catch (Exception ex) {
            log.error("No such repository path " + path);
            log.error("Exception:", (Throwable)ex);
            return null;
        }
    }

    protected IDavItem bridge(RepositoryElement item) {
        if (item instanceof RepositoryContent) {
            return new BridgeRepositoryContent((IDavRepo)this, (RepositoryContent)item);
        }
        return new BridgeRepositoryDirectory((IDavRepo)this, (RepositoryDirectory)item);
    }

    @Override
    public Collection<IDavItem> getItems(IDavContext ctxt, IDavItem item, int depth) {
        ArrayList<IDavItem> items = new ArrayList<IDavItem>();
        items.add(item);
        if (item instanceof IDavCollection) {
            BridgeRepository.addChildItems(ctxt, items, (IDavCollection)item, depth);
        }
        return items;
    }

    private static void addChildItems(IDavContext ctxt, ArrayList<IDavItem> collection, IDavCollection dirItem, int depth) {
        if (depth == 0) {
            return;
        }
        ArrayList<IDavItem> childItems = dirItem.getChildren(ctxt);
        collection.addAll(childItems);
        for (IDavItem item : childItems) {
            if (!(item instanceof IDavCollection)) continue;
            BridgeRepository.addChildItems(ctxt, collection, (IDavCollection)item, depth - 1);
        }
    }

    @Override
    public IDavItem getRepositoryRoot(IDavContext ctxt) {
        return new BridgeRepositoryDirectory((IDavRepo)this, this.rootElement);
    }

    @Override
    public boolean supportsLocking() {
        return false;
    }

    @Override
    public IMimeTypeResolver getMimeTypeResolver() {
        return this.mimeTypeResolver;
    }

    @Override
    public void setMimeTypeResolver(IMimeTypeResolver resolver) {
        this.mimeTypeResolver = resolver;
    }
}

