/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.RepositoryPlugin;
import com.nirima.jenkins.bridge.BridgeRepository;
import com.nirima.jenkins.repo.build.ProjectBuildRepositoryRoot;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TransientBuildActionFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class TransientBuildActionFactoryImpl
extends TransientBuildActionFactory {
    @Inject
    RepositoryPlugin plugin;

    public Collection<? extends Action> createFor(AbstractBuild build) {
        return Collections.singleton(new BuildActionImpl(build));
    }

    public class BuildActionImpl
    implements Action {
        private final AbstractBuild build;

        public BuildActionImpl(AbstractBuild build) {
            this.build = build;
        }

        public String getIconFileName() {
            return TransientBuildActionFactoryImpl.this.plugin.getIconFileName();
        }

        public String getDisplayName() {
            return "Build Artifacts As Maven Repository";
        }

        public String getUrlName() {
            return "maven-repository";
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            TransientBuildActionFactoryImpl.this.plugin.serveRequest(new BridgeRepository(new ProjectBuildRepositoryRoot(null, (Run)this.build, this.build.getFullDisplayName()), null), req.findAncestor((Object)this).getUrl());
        }
    }
}

