/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.SelectionType;
import com.nirima.jenkins.action.ProjectRepositoryAction;
import com.nirima.jenkins.action.RepositoryAction;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.RunParameterValue;
import java.net.MalformedURLException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelectionTypeUpstream
extends SelectionType {
    public String build;

    @DataBoundConstructor
    public SelectionTypeUpstream(String build) {
        this.build = build;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String buildId) {
        this.build = this.build;
    }

    @Override
    public RepositoryAction getAction(Run<?, ?> b) throws MalformedURLException, SelectionType.RepositoryDoesNotExistException {
        int theBuild;
        String theProject;
        Cause.UpstreamCause theCause = (Cause.UpstreamCause)b.getCause(Cause.UpstreamCause.class);
        if (theCause == null) {
            ParametersAction action = (ParametersAction)b.getAction(ParametersAction.class);
            if (action == null) {
                throw new SelectionType.RepositoryDoesNotExistException(this);
            }
            RunParameterValue value = (RunParameterValue)action.getParameter("Upstream");
            theProject = value.getJobName();
            theBuild = Integer.parseInt(value.getNumber());
        } else {
            theProject = theCause.getUpstreamProject();
            theBuild = theCause.getUpstreamBuild();
        }
        return new ProjectRepositoryAction(theProject, theBuild, this.build);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SelectionType> {
        public String getDisplayName() {
            return "Upstream Project that triggered this build";
        }
    }
}

