/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.nirima.jenkins.SelectionType;
import com.nirima.jenkins.action.ProjectRepositoryAction;
import com.nirima.jenkins.action.RepositoryAction;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import java.net.MalformedURLException;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelectionTypeProject
extends SelectionType {
    public String project;
    public String build;
    public String promoted;

    @DataBoundConstructor
    public SelectionTypeProject(String project, String build, String promoted) {
        this.project = project;
        this.build = build;
        this.promoted = promoted;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String buildId) {
        this.build = buildId;
    }

    public String getPromoted() {
        return this.promoted;
    }

    public void setPromoted(String promoted) {
        this.promoted = promoted;
    }

    @Override
    public RepositoryAction getAction(Run<?, ?> theBuild) throws MalformedURLException, SelectionType.RepositoryDoesNotExistException {
        int id;
        String suffix;
        if (this.build.equalsIgnoreCase("promotedRepository")) {
            suffix = "repository";
            id = this.getPromotedBuildNumber(this.project, this.promoted);
        } else if (this.build.equalsIgnoreCase("promotedRepositoryChain")) {
            suffix = "repositoryChain";
            id = this.getPromotedBuildNumber(this.project, this.promoted);
        } else {
            suffix = this.build;
            id = this.getLastSuccessfulBuildNumber(this.project);
        }
        return new ProjectRepositoryAction(this.project, id, suffix);
    }

    private BuildableItemWithBuildWrappers getProject(final String project) {
        BuildableItemWithBuildWrappers item = (BuildableItemWithBuildWrappers)Iterables.find((Iterable)Jenkins.getInstance().getAllItems(BuildableItemWithBuildWrappers.class), (Predicate)new Predicate<BuildableItemWithBuildWrappers>(){

            public boolean apply(BuildableItemWithBuildWrappers buildableItemWithBuildWrappers) {
                return buildableItemWithBuildWrappers.getName().equals(project);
            }
        });
        return item;
    }

    private int getLastSuccessfulBuildNumber(String project) {
        BuildableItemWithBuildWrappers item = this.getProject(project);
        return ((AbstractBuild)item.asProject().getLastSuccessfulBuild()).getNumber();
    }

    private int getPromotedBuildNumber(String project, final String promoted) {
        BuildableItemWithBuildWrappers item = this.getProject(project);
        Iterable promotedItems = Iterables.filter((Iterable)item.asProject().getBuilds(), (Predicate)new Predicate(){

            public boolean apply(Object o) {
                AbstractBuild abstractBuild = (AbstractBuild)o;
                PromotedBuildAction pba = (PromotedBuildAction)abstractBuild.getAction(PromotedBuildAction.class);
                return pba != null && pba.getPromotion(promoted) != null;
            }
        });
        Ordering<AbstractBuild> ordering = new Ordering<AbstractBuild>(){

            public int compare(AbstractBuild l, AbstractBuild r) {
                return r.getNumber() - l.getNumber();
            }
        };
        try {
            return ((AbstractBuild)ordering.max(promotedItems)).getNumber();
        }
        catch (Exception ex) {
            throw new RuntimeException("No promotion of type " + promoted + " in project " + project);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SelectionType> {
        public String getDisplayName() {
            return "Project";
        }

        public List<BuildableItemWithBuildWrappers> getJobs() {
            return Jenkins.getInstance().getAllItems(BuildableItemWithBuildWrappers.class);
        }
    }
}

