/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.bridge.BridgeRepository;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.update.BuildUpdater;
import com.nirima.jenkins.webdav.impl.MethodFactory;
import com.nirima.jenkins.webdav.impl.ServletContextMimeTypeResolver;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.IMethod;
import com.nirima.jenkins.webdav.interfaces.IMethodFactory;
import hudson.Extension;
import hudson.Functions;
import hudson.Plugin;
import hudson.model.Build;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.RootAction;
import hudson.plugins.git.util.BuildData;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class RepositoryPlugin
extends Plugin
implements RootAction,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryPlugin.class);
    private ServletContext context;
    private IMethodFactory methodFactory = new MethodFactory();
    public static String DISPLAY_NAME = "Jenkins Maven Repository Server";
    public static String URL = "repository";

    public String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/repository/static/icons/repository-32x32.png";
    }

    public String getDisplayName() {
        return "Maven Repository";
    }

    public String getUrlName() {
        return "plugin/repository";
    }

    public void start() {
        File root = new File(Jenkins.getInstance().getRootDir(), "repositoryPlugin");
        root.mkdirs();
        String file = this.getClass().getResource('/' + this.getClass().getName().replace('.', '/') + ".class").getFile();
        if (file.startsWith("file:")) {
            file = file.substring(5, file.indexOf(33));
        }
        try {
            logger.info("Expanding " + file + " into " + root);
            this.expand(new File(file), root, "tools");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void expand(File jarFile, File destDir, String prefix) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            if (!file.getName().startsWith(prefix)) continue;
            File f = new File(destDir, file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        String fullPath = req.getPathInfo();
        if (path.length() == 0) {
            path = "/";
        }
        if (req.getMethod().equals("POST") && path.startsWith("/add_info")) {
            BuildUpdater bu = new BuildUpdater(req, rsp);
            bu.execute();
            return;
        }
        if (path.indexOf("..") != -1 || path.length() < 1) {
            rsp.sendError(400);
            return;
        }
        if (path.startsWith("/static")) {
            super.doDynamic(req, rsp);
            return;
        }
        this.serveRequest(new BridgeRepository(null), req.getContextPath() + "/plugin/repository");
    }

    public void serveRequest(IDavRepo repo, String root) {
        StaplerRequest req = Stapler.getCurrentRequest();
        StaplerResponse rsp = Stapler.getCurrentResponse();
        try {
            if (repo.getMimeTypeResolver() == null) {
                ServletContextMimeTypeResolver ctx = new ServletContextMimeTypeResolver();
                ctx.setServletContext(req.getSession().getServletContext());
                repo.setMimeTypeResolver(ctx);
            }
            IMethod method = this.methodFactory.createMethod((HttpServletRequest)req, (HttpServletResponse)rsp);
            method.init((HttpServletRequest)req, (HttpServletResponse)rsp, null, repo, root);
            method.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error trying to serve request");
            throw new RuntimeException(e);
        }
    }

    private void displayElement(StaplerRequest req, StaplerResponse rsp, RepositoryElement currentItem) throws Exception {
        ServletOutputStream os = rsp.getOutputStream();
        if (currentItem instanceof RepositoryDirectory) {
            rsp.setContentType("text/html;charset=UTF-8");
            this.printHeader((OutputStream)os, req, (RepositoryDirectory)currentItem);
            for (RepositoryElement repositoryElement : ((RepositoryDirectory)currentItem).getChildren()) {
                this.printDirEntry((OutputStream)os, repositoryElement);
            }
            this.printFooter((OutputStream)os);
        } else {
            RepositoryContent content = (RepositoryContent)currentItem;
            String string = content.getContentType();
            if (string != null) {
                rsp.setContentType(string);
            }
            InputStream is = content.getContent();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
        }
    }

    private Build getBuild(Project theProject, String type, String ref) {
        if (type.equals("build")) {
            int nbr = Integer.parseInt(ref);
            for (Object object : theProject.getBuilds()) {
                Build r = (Build)object;
                if (r.getNumber() != nbr) continue;
                return r;
            }
        } else {
            for (Object object : theProject.getBuilds()) {
                Build r = (Build)object;
                BuildData bd = (BuildData)r.getAction(BuildData.class);
                if (bd == null || !bd.getLastBuiltRevision().getSha1String().equals(ref)) continue;
                return r;
            }
        }
        return null;
    }

    private void printHeader(OutputStream os, StaplerRequest req, RepositoryDirectory directory) throws IOException {
        String title = "<html>\n  <head>\n    <title>Index of " + directory.getPath() + "</title>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n    <link rel=\"stylesheet\" href=\"" + req.getContextPath() + "/plugin/repository/css/repository-style.css\" type=\"text/css\" media=\"screen\" title=\"no title\" charset=\"utf-8\">\n  </head>\n  <body>\n    <h1>Index of " + directory.getPath() + "</h1>\n    <table cellspacing=\"10\">\n      <tr>\n        <th align=\"left\">Name</th>\n        <th>Last Modified</th>\n        <th>Size</th>\n        <th>Description</th>\n      </tr>";
        String parent = "<tr>\n        <td>\n          <a href=\"../\">Parent Directory</a>\n        </td>\n      </tr>";
        os.write(title.getBytes("UTF-8"));
        if (directory.getParent() != null) {
            os.write(parent.getBytes("UTF-8"));
        }
    }

    private void printFooter(OutputStream os) throws IOException {
        String footer = "            </table>\n  </body>\n</html>";
        os.write(footer.getBytes("UTF-8"));
    }

    private void printDirEntry(OutputStream os, RepositoryElement item) throws IOException {
        String name = item.getName();
        String lastModified = "";
        String size = "";
        String description = "";
        if (item instanceof RepositoryDirectory) {
            name = name + "/";
        }
        if (item instanceof RepositoryContent) {
            size = "" + ((RepositoryContent)item).getSize();
        }
        description = item.getDescription();
        String entry = "      <tr>\n            <td>\n                              <a href=\"" + name + "\">" + name + "</a>\n                          </td>\n            <td>\n              " + lastModified + "\n            </td>\n            <td align=\"right\">\n                   " + size + "\n                          </td>\n            <td>\n              " + description + "\n            </td>\n          </tr>";
        os.write(entry.getBytes("UTF-8"));
    }

    private Project getProject(String pathElement) {
        for (Project project : Hudson.getInstance().getProjects()) {
            if (!project.getName().equals(pathElement)) continue;
            return project;
        }
        return null;
    }
}

