/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.SelectionType;
import com.nirima.jenkins.action.RepositoryAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RepositoryDefinitionProperty
extends SimpleBuildWrapper
implements Serializable {
    public SelectionType upstream;

    @DataBoundConstructor
    public RepositoryDefinitionProperty(SelectionType upstream) {
        this.upstream = upstream;
    }

    public SelectionType getUpstream() {
        return this.upstream;
    }

    public void setUpstream(SelectionType upstream) {
        this.upstream = upstream;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        try {
            RepositoryAction repositoryAction = this.upstream.getAction(build);
            build.addAction((Action)repositoryAction);
            context.env("Jenkins.Repository", repositoryAction.getUrl().toExternalForm());
            listener.getLogger().println("Setting environment Jenkins.Repository = " + repositoryAction.getUrl().toExternalForm());
        }
        catch (SelectionType.RepositoryDoesNotExistException x) {
            listener.getLogger().println("You asked for an upstream repository, but it does not exist");
            throw new RuntimeException(x);
        }
        catch (MalformedURLException e) {
            listener.getLogger().println("Problem setting upstream repository URL");
            throw new RuntimeException(e);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Define Upstream Maven Repository";
        }

        public boolean isApplicable(AbstractProject<?, ?> abstractProject) {
            return true;
        }
    }
}

