/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl.methods;

import com.nirima.jenkins.webdav.impl.DAVItemSerializer;
import com.nirima.jenkins.webdav.impl.methods.MethodBase;
import com.nirima.jenkins.webdav.interfaces.IDavCollection;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.IDavLock;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.MethodException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

public class Lock
extends MethodBase {
    private static Logger s_logger = Logger.getLogger(Lock.class);

    public void invoke(IDavContext ctxt) throws MethodException {
        IDavLock lockItem;
        String lockToken = this.parseIfHeader();
        int timeout = this.getHeaderTime("Timeout", -1);
        boolean created = false;
        if (!this.getRepo().supportsLocking()) {
            this.getResponse().setStatus(412);
            return;
        }
        IDavItem item = this.getRepo().getItem(this.getDavContext(), this.getPath());
        if (item == null) {
            IDavRepo repo = this.getRepo();
            int lastSlash = this.getPath().lastIndexOf("/");
            String parent = this.getPath().substring(0, lastSlash);
            IDavCollection parentFolder = (IDavCollection)repo.getItem(this.getDavContext(), parent);
            item = parentFolder.createItem(this.getDavContext(), this.getPath().substring(lastSlash + 1));
            created = true;
        }
        s_logger.info((Object)("Locking request for " + timeout + "secs"));
        if (lockToken != null) {
            lockItem = item.getLock(ctxt, lockToken);
            lockItem.renew(timeout);
        } else {
            lockItem = item.lock(ctxt, timeout);
        }
        XMLStreamWriter response = this.createXmlResponse();
        DAVItemSerializer dis = new DAVItemSerializer();
        try {
            response.setPrefix("a", "DAV:");
            response.writeStartElement("DAV:", "prop");
            dis.generateLockXml(response, lockItem);
            response.writeEndElement();
            response.writeEndDocument();
            response.flush();
            response.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MethodException("Error generating lock XML", e);
        }
        if (created) {
            this.getResponse().setStatus(201);
        }
    }
}

