/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.token;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.RunParameterValue;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class RepositoryTokenMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=false)
    boolean chain;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("REPOSITORY_UPSTREAM");
    }

    public String evaluate(AbstractBuild<?, ?> abstractBuild, TaskListener taskListener, String s) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            String theProject = null;
            String theBuild = null;
            Cause.UpstreamCause theCause = (Cause.UpstreamCause)abstractBuild.getCause(Cause.UpstreamCause.class);
            if (theCause == null) {
                ParametersAction action = (ParametersAction)abstractBuild.getAction(ParametersAction.class);
                RunParameterValue value = (RunParameterValue)action.getParameter("Upstream");
                theProject = value.getJobName();
                theBuild = value.getNumber();
            } else {
                theProject = theCause.getUpstreamProject();
                theBuild = "" + theCause.getUpstreamBuild();
            }
            String root = Hudson.getInstance().getRootUrl() + "plugin/repository/project/" + theProject + "/Build/" + theBuild;
            if (this.chain) {
                return root + "/repositoryChain/";
            }
            return root + "/repository/";
        }
        catch (Exception ex) {
            return "";
        }
    }
}

