/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.virtual;

import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.DirectoryRepositoryItem;
import com.nirima.jenkins.repo.build.PopulateOnDemandDirectoryRepositoryItem;
import com.nirima.jenkins.repo.build.ProjectBuildRepositoryRoot;
import com.nirima.jenkins.repo.util.HudsonVisitor;
import com.nirima.jenkins.repo.util.HudsonWalker;
import com.nirima.jenkins.repo.util.IDirectoryPopulator;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.util.BuildData;

public class AllSHA1RepositoryRoot
extends PopulateOnDemandDirectoryRepositoryItem {
    public AllSHA1RepositoryRoot(RepositoryDirectory parent) {
        super(parent, "SHA1");
    }

    protected IDirectoryPopulator getPopulator() {
        return new IDirectoryPopulator(){

            public void populate(DirectoryRepositoryItem directory) {
                HudsonWalker.traverseProjectsAndBuilds(new HudsonVisitor(){

                    public void visitModuleSet(MavenModuleSetBuild run) {
                        BuildData bd = (BuildData)run.getAction(BuildData.class);
                        if (bd != null && run.getResult() == Result.SUCCESS) {
                            String sha1 = bd.getLastBuiltRevision().getSha1String();
                            ProjectBuildRepositoryRoot content = new ProjectBuildRepositoryRoot(AllSHA1RepositoryRoot.this, (Run)run, sha1);
                            AllSHA1RepositoryRoot.this.add(content, false);
                        }
                    }
                });
            }
        };
    }
}

