/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.project;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.nirima.jenkins.repo.AbstractRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.ProjectBuildRepositoryRoot;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.util.BuildData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuildList
extends AbstractRepositoryDirectory
implements RepositoryDirectory {
    Type type;
    BuildableItemWithBuildWrappers item;

    protected ProjectBuildList(RepositoryDirectory parent, BuildableItemWithBuildWrappers item, Type type) {
        super(parent);
        this.type = type;
        this.item = item;
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    public Collection<ProjectBuildRepositoryRoot> getChildren() {
        if (this.type == Type.Build) {
            ArrayList children = new ArrayList();
            Function<Run, ProjectBuildRepositoryRoot> fn = new Function<Run, ProjectBuildRepositoryRoot>(){

                public ProjectBuildRepositoryRoot apply(Run r) {
                    if (r.getResult() != Result.SUCCESS) {
                        return null;
                    }
                    return new ProjectBuildRepositoryRoot(ProjectBuildList.this, r, "" + r.getNumber());
                }
            };
            Iterable i = Iterables.transform((Iterable)this.item.asProject().getBuilds(), (Function)fn);
            Iterables.removeAll((Iterable)i, (Collection)Lists.newArrayList((Object[])new ProjectBuildRepositoryRoot[]{null}));
            return Lists.newArrayList((Iterable)i);
        }
        HashMap<String, ProjectBuildRepositoryRoot> children = new HashMap<String, ProjectBuildRepositoryRoot>();
        for (AbstractBuild run : this.item.asProject().getBuilds()) {
            String sha1;
            BuildData bd = (BuildData)run.getAction(BuildData.class);
            if (bd == null || run.getResult() != Result.SUCCESS || children.containsKey(sha1 = bd.getLastBuiltRevision().getSha1String()) || !run.getResult().isBetterOrEqualTo(Result.SUCCESS)) continue;
            children.put(sha1, new ProjectBuildRepositoryRoot(this, (Run)run, sha1));
        }
        return children.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SHA1,
        Build;

    }
}

