/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.build.ArtifactRepositoryItem;
import com.nirima.jenkins.repo.build.TextRepositoryItem;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.model.Run;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MetadataRepositoryItem
extends TextRepositoryItem {
    private MavenBuild build;
    private String groupId;
    private String artifactId;
    private String version;
    private Map<MavenArtifact, ArtifactRepositoryItem> items = new HashMap<MavenArtifact, ArtifactRepositoryItem>();
    protected static SimpleDateFormat _ufmt = new SimpleDateFormat("yyyyMMddHHmmss");
    protected static SimpleDateFormat _vfmt = new SimpleDateFormat("yyyyMMdd.HHmmss");

    private static String formatDateVersion(Date date, int buildNo) {
        return _vfmt.format(date) + "-" + buildNo;
    }

    public static String formatDateVersion(Run buildRun) {
        return MetadataRepositoryItem.formatDateVersion(buildRun.getTime(), buildRun.getNumber());
    }

    public MetadataRepositoryItem(MavenBuild build, MavenArtifact artifact) {
        this.build = build;
        this.groupId = artifact.groupId;
        this.artifactId = artifact.artifactId;
        this.version = artifact.version;
    }

    public String getPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.getName();
    }

    public void addArtifact(MavenArtifact artifact, ArtifactRepositoryItem item) {
        this.items.put(artifact, item);
    }

    public String getName() {
        return "maven-metadata.xml";
    }

    public Date getLastModified() {
        long lastModified = 0L;
        for (ArtifactRepositoryItem item : this.items.values()) {
            lastModified = Math.max(lastModified, item.getLastModified().getTime());
        }
        return new Date(lastModified);
    }

    public String getDescription() {
        return "From Build #" + this.build.getNumber() + " of " + this.build.getParentBuild().getParent().getName();
    }

    public String getContentType() {
        return "application/xml";
    }

    protected String generateContent() {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<metadata modelVersion=\"1.1.0\">\n");
        buf.append("  <groupId>" + this.groupId + "</groupId>\n");
        buf.append("  <artifactId>" + this.artifactId + "</artifactId>\n");
        buf.append("  <version>" + this.version + "</version>\n");
        buf.append("  <versioning>\n");
        buf.append("    <snapshotVersions>\n");
        HashMap<String, Entry> entryToBuild = new HashMap<String, Entry>();
        for (Map.Entry<MavenArtifact, ArtifactRepositoryItem> entry : this.items.entrySet()) {
            Entry e = new Entry(entry);
            String id = e.toString();
            if (entryToBuild.containsKey(id)) {
                Entry current = (Entry)entryToBuild.get(id);
                if (!e.isNewerThan(current)) continue;
                entryToBuild.put(id, e);
                continue;
            }
            entryToBuild.put(id, e);
        }
        for (Entry e : entryToBuild.values()) {
            e.getSnapshotXml(buf);
        }
        buf.append("    </snapshotVersions>\n");
        buf.append("  </versioning>\n");
        buf.append("</metadata>\n");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry {
        MavenArtifact theArtifact;
        ArtifactRepositoryItem theItem;

        public Entry(Map.Entry<MavenArtifact, ArtifactRepositoryItem> entry) {
            this.theArtifact = entry.getKey();
            this.theItem = entry.getValue();
        }

        public void getSnapshotXml(StringBuilder buf) {
            String dateVers = MetadataRepositoryItem.formatDateVersion((Run)this.theItem.getBuild());
            String itemVersion = MetadataRepositoryItem.this.version.replaceAll("SNAPSHOT", dateVers);
            String lastMod = _ufmt.format(this.theItem.getLastModified());
            buf.append("      <snapshotVersion>\n");
            if (this.theArtifact.classifier != null && this.theArtifact.classifier.length() > 0) {
                buf.append("        <classifier>").append(this.theArtifact.classifier).append("</classifier>\n");
            }
            buf.append("        <extension>").append(this.theArtifact.type).append("</extension>\n");
            buf.append("        <value>").append(itemVersion).append("</value>\n");
            buf.append("        <updated>").append(lastMod).append("</updated>\n");
            buf.append("      </snapshotVersion>\n");
        }

        public String toString() {
            return this.theArtifact.type + ":" + this.theArtifact.classifier;
        }

        public boolean isNewerThan(Entry otherEntry) {
            return this.theItem.getLastModified().after(otherEntry.theItem.getLastModified());
        }
    }
}

