/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.RepositoryPlugin;
import com.nirima.jenkins.repo.AbstractRepositoryElement;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryRepositoryItem
extends AbstractRepositoryElement
implements RepositoryDirectory {
    private static final Logger LOGGER = Logger.getLogger(RepositoryPlugin.class.getName());
    protected Map<String, RepositoryElement> items;
    protected String name;

    public DirectoryRepositoryItem(RepositoryDirectory parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Map<String, RepositoryElement> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, RepositoryElement>();
        }
        return this.items;
    }

    @Override
    public Collection<? extends RepositoryElement> getChildren() {
        return this.getItems().values();
    }

    public void insert(RepositoryContent content, String path, boolean allowOverwrite) {
        if (path.contains("/")) {
            int idx = path.indexOf("/");
            String dir = path.substring(0, idx);
            String rest = path.substring(idx + 1);
            RepositoryElement dirElement = this.getChild(dir);
            if (dirElement == null) {
                dirElement = this.add(new DirectoryRepositoryItem(this, dir), allowOverwrite);
            }
            ((DirectoryRepositoryItem)dirElement).insert(content, rest, allowOverwrite);
        } else {
            this.add(content, allowOverwrite);
        }
    }

    protected RepositoryElement add(RepositoryElement dirElement, boolean allowOverwrite) {
        if (this.getItems().containsKey(dirElement.getName()) && !allowOverwrite) {
            return this.items.get(dirElement.getName());
        }
        this.getItems().put(dirElement.getName(), dirElement);
        dirElement.setParent(this);
        return dirElement;
    }

    @Override
    public RepositoryElement getChild(String element) {
        return this.getItems().get(element);
    }
}

