/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.SelectionType;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RepositoryDefinitionProperty
extends BuildWrapper
implements Serializable {
    public SelectionType upstream;

    @DataBoundConstructor
    public RepositoryDefinitionProperty(SelectionType upstream) {
        this.upstream = upstream;
    }

    public SelectionType getUpstream() {
        return this.upstream;
    }

    public void setUpstream(SelectionType upstream) {
        this.upstream = upstream;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                super.buildEnvVars(env);
                try {
                    URL url = RepositoryDefinitionProperty.this.upstream.getUrl(build);
                    env.put("Jenkins.Repository", url.toExternalForm());
                    listener.getLogger().println("Setting environment Jenkins.Repository = " + url.toExternalForm());
                }
                catch (SelectionType.RepositoryDoesNotExistException x) {
                    listener.getLogger().println("You asked for an upstream repository, but it does not exist");
                    throw new RuntimeException(x);
                }
                catch (MalformedURLException e) {
                    listener.getLogger().println("Problem setting upstream repository URL");
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Define Upstream Maven Repository";
        }

        public boolean isApplicable(AbstractProject<?, ?> abstractProject) {
            return true;
        }
    }
}

