// CHECKSTYLE:OFF

package jenkins.plugins.simpleclearcase;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Lacking starting slash on load rule
     * 
     */
    public static String simpleclearcase_loadRules_lacking_slash() {
        return holder.format("simpleclearcase.loadRules.lacking.slash");
    }

    /**
     * Lacking starting slash on load rule
     * 
     */
    public static Localizable _simpleclearcase_loadRules_lacking_slash() {
        return new Localizable(holder, "simpleclearcase.loadRules.lacking.slash");
    }

    /**
     * Cannot set branch without load rules and viewname
     * 
     */
    public static String simpleclearcase_branch_requirements() {
        return holder.format("simpleclearcase.branch.requirements");
    }

    /**
     * Cannot set branch without load rules and viewname
     * 
     */
    public static Localizable _simpleclearcase_branch_requirements() {
        return new Localizable(holder, "simpleclearcase.branch.requirements");
    }

    /**
     * Branch cannot contain white space
     * 
     */
    public static String simpleclearcase_branch_whitespace() {
        return holder.format("simpleclearcase.branch.whitespace");
    }

    /**
     * Branch cannot contain white space
     * 
     */
    public static Localizable _simpleclearcase_branch_whitespace() {
        return new Localizable(holder, "simpleclearcase.branch.whitespace");
    }

    /**
     * Load rules cannot be empty
     * 
     */
    public static String simpleclearcase_loadRules_empty() {
        return holder.format("simpleclearcase.loadRules.empty");
    }

    /**
     * Load rules cannot be empty
     * 
     */
    public static Localizable _simpleclearcase_loadRules_empty() {
        return new Localizable(holder, "simpleclearcase.loadRules.empty");
    }

    /**
     * Viewname cannot contain white space
     * 
     */
    public static String simpleclearcase_viewname_whitespace() {
        return holder.format("simpleclearcase.viewname.whitespace");
    }

    /**
     * Viewname cannot contain white space
     * 
     */
    public static Localizable _simpleclearcase_viewname_whitespace() {
        return new Localizable(holder, "simpleclearcase.viewname.whitespace");
    }

    /**
     * Viewname cannot be empty
     * 
     */
    public static String simpleclearcase_viewname_empty() {
        return holder.format("simpleclearcase.viewname.empty");
    }

    /**
     * Viewname cannot be empty
     * 
     */
    public static Localizable _simpleclearcase_viewname_empty() {
        return new Localizable(holder, "simpleclearcase.viewname.empty");
    }

    /**
     * There isn't any branch on load rule:
     * 
     */
    public static String simpleclearcase_branch_missingbranchforpath() {
        return holder.format("simpleclearcase.branch.missingbranchforpath");
    }

    /**
     * There isn't any branch on load rule:
     * 
     */
    public static Localizable _simpleclearcase_branch_missingbranchforpath() {
        return new Localizable(holder, "simpleclearcase.branch.missingbranchforpath");
    }

    /**
     * Load rule path doesn't exist in ClearCase repository, please review your load rules and view. Load rule:
     * 
     */
    public static String simpleclearcase_loadRules_pathdoesnotexist() {
        return holder.format("simpleclearcase.loadRules.pathdoesnotexist");
    }

    /**
     * Load rule path doesn't exist in ClearCase repository, please review your load rules and view. Load rule:
     * 
     */
    public static Localizable _simpleclearcase_loadRules_pathdoesnotexist() {
        return new Localizable(holder, "simpleclearcase.loadRules.pathdoesnotexist");
    }

    /**
     * Simple Dynamic ClearCase
     * 
     */
    public static String simpleclearcase_DisplayName() {
        return holder.format("simpleclearcase.DisplayName");
    }

    /**
     * Simple Dynamic ClearCase
     * 
     */
    public static Localizable _simpleclearcase_DisplayName() {
        return new Localizable(holder, "simpleclearcase.DisplayName");
    }

    /**
     * Remove duplicated load rules
     * 
     */
    public static String simpleclearcase_loadRules_duplicated_loadrule() {
        return holder.format("simpleclearcase.loadRules.duplicated.loadrule");
    }

    /**
     * Remove duplicated load rules
     * 
     */
    public static Localizable _simpleclearcase_loadRules_duplicated_loadrule() {
        return new Localizable(holder, "simpleclearcase.loadRules.duplicated.loadrule");
    }

    /**
     * A load rule cannot end with a slash, remove the trailing slash
     * 
     */
    public static String simpleclearcase_loadRules_trailingslash() {
        return holder.format("simpleclearcase.loadRules.trailingslash");
    }

    /**
     * A load rule cannot end with a slash, remove the trailing slash
     * 
     */
    public static Localizable _simpleclearcase_loadRules_trailingslash() {
        return new Localizable(holder, "simpleclearcase.loadRules.trailingslash");
    }

    /**
     * Chosen viewname doesn't exist
     * 
     */
    public static String simpleclearcase_viewname_doesntexist() {
        return holder.format("simpleclearcase.viewname.doesntexist");
    }

    /**
     * Chosen viewname doesn't exist
     * 
     */
    public static Localizable _simpleclearcase_viewname_doesntexist() {
        return new Localizable(holder, "simpleclearcase.viewname.doesntexist");
    }

    /**
     * Load Rule is prefix of another load rule, which we cannot have, as we fetch commit history recursively. Load rule: 
     * 
     */
    public static String simpleclearcase_loadRules_loadruleprefixed() {
        return holder.format("simpleclearcase.loadRules.loadruleprefixed");
    }

    /**
     * Load Rule is prefix of another load rule, which we cannot have, as we fetch commit history recursively. Load rule: 
     * 
     */
    public static Localizable _simpleclearcase_loadRules_loadruleprefixed() {
        return new Localizable(holder, "simpleclearcase.loadRules.loadruleprefixed");
    }

}
